<?php
class CdProduct {
    public $playLength;
    public $title;
    public $producerMainName;
    public $producerFirstName;
    public $price;

    function __construct(   $title, $firstName, 
                            $mainName, $price, 
                            $playLength ) { 
        $this->title             = $title;
        $this->producerFirstName = $firstName;
        $this->producerMainName  = $mainName;
        $this->price             = $price;
        $this->playLength        = $playLength;

    }

    function getPlayLength() {
        return $this->playLength;
    }

    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        $base .= ": czas nagrania - $this->playLength";
        return $base;
    }

    function getProducer() {
        return "{$this->producerFirstName}".
               " {$this->producerMainName}";
    }
}

class BookProduct {
    public $numPages;
    public $title;
    public $producerMainName;
    public $producerFirstName;
    public $price;

    function __construct(   $title, $firstName, 
                            $mainName, $price, 
                            $numPages ) { 
        $this->title             = $title;
        $this->producerFirstName = $firstName;
        $this->producerMainName  = $mainName;
        $this->price             = $price;
        $this->numPages          = $numPages;
    }
 
    function getNumberOfPages() {
        return $this->numPages;
    }

    function getSummaryLine() {
        $base  = "$this->title ( $this->producerMainName, ";
        $base .= "$this->producerFirstName )"; 
        $base .= ": liczba stron - $this->numPages";
        return $base;
    }

    function getProducer() {
        return "{$this->producerFirstName}".
               " {$this->producerMainName}";
    }

}

$product1 = new BookProduct(    "Moja Antonia", "Willa", "Cather", 59.99, 300 );
$product2 =   new CdProduct(    "Exile on Coldharbour Lane", 
                                "The", "Alabama 3", 25.99, 60.33 );

print "Autor:          ".$product1->getProducer()."\n";
print "Liczba stron:   ".$product1->getNumberOfPages()."\n";
print "Opis:           ".$product1->getSummaryLine()."\n";
print "Wykonawca:      ".$product2->getProducer()."\n";
print "Czas nagrania:  ".$product2->getPlayLength()."\n";
print "Opis:           ".$product2->getSummaryLine()."\n";
?>
