<?php
/**
 * @license   http://www.example.com Otwarta licencja Borsetshire
 * @package   command
 */

/**
 * Definiuje rdzenne funkcje polece.
 * Klasy hierachii Command realizuj konkretne zadania w systemie
 * za porednictwem metody
 * {@link execute()}
 *
 * @package command
 * @author  Clarrie Grundie
 * @copyright 2004 Ambridge Technologies Ltd
 */
abstract class Command {

/**
 * Realizuje polecenie hermetyzowanym w klasie.
 * Kada klasa z hierarchii Command hermeryzuje jedno polecenie.
 * Klasy te mona atwo dodawa do projektu i z niego usuwa;
 * utworzony egzemplarz moe oczekiwa na wywoanie metody
 * execute() w wolnym czasie.
 * @param  $context {@link CommandContext} wspuytkowane dane - kontekst polecenia
 * @return bool     false w przypadku poraki, true w razie powodzenia
 * @uses CommandContext
 * @link http://www.example.com Wicej informacji
 */
    abstract function execute( CommandContext $context );
}


?>
