<?php
require_once( 'woo/process/Base.php' );

class woo_process_VenueManager extends woo_process_Base {
    static $add_venue =  "INSERT INTO venue 
                          ( id, name ) 
                          values( ?, ? )";
    static $add_space  = "INSERT INTO space
                          ( id, name, venue ) 
                          values( ?, ?, ? )"; 
    static $check_slot = "SELECT id, name 
                          FROM event 
                          WHERE space=? 
                          AND (start+duration) > ? 
                          AND start < ?"; 
    static $add_event =  "INSERT INTO event 
                          ( id, name, space, start, duration ) 
                          values( ?, ?, ?, ?, ? )"; 

    function addVenue( $name, $space_array ) {
        $ret = array();
        $v_id = self::$DB->nextId('venue');
        $ret['venue'] = array( $v_id, $name ); 
        $this->doStatement( self::$add_venue, $ret['venue']);
        $ret['spaces'] = array();
        foreach ( $space_array as $space_name ) {
            $s_id = self::$DB->nextId('space');
            $values = array($s_id, $space_name, $v_id );
            $this->doStatement( self::$add_space, $values);
            $ret['spaces'][] = $values;
        }
        return $ret;
    }
    
    function bookEvent( $venue_id, $name, $time, $duration ) {
        $result = 
            $this->doStatement( self::$check_slot, 
                array( $venue_id, $time, ($time+$duration) ) );
        if ( $result->numRows() > 0 ) {
            throw new woo_base_AppException( "Ju zarezerwowane! Sprbuj ponownie" );
        }
        $e_id = self::$DB->nextId('event');
        $this->doStatement( self::$add_event, 
            array( $e_id, $name, $venue_id, $time, $duration ) );
    } 
}
?>
