<?php

interface Observable {
    function attach( Observer $observer );
    function detach( Observer $observer );
    function notify();
}

class Login implements Observable {
    private $observers = array();
    const LOGIN_USER_UNKNOWN = 1;
    const LOGIN_WRONG_PASS   = 2;
    const LOGIN_ACCESS       = 3;

    function attach( Observer $observer ) {
        $this->observers[] = $observer;
    }

    function detach( Observer $observer ) {
        $this->observers = array_diff( $this->observers, array($observer) );
    }

    function notify() {
        foreach ( $this->observers as $obs ) {
            $obs->update( $this );
        }
    }

    function handleLogin( $user, $pass, $ip ) {
        switch ( rand(1,3) ) {
            case 1: 
                $this->setStatus( self::LOGIN_ACCESS, $user, $ip );
                $ret = true; break;
            case 2:
                $this->setStatus( self::LOGIN_WRONG_PASS, $user, $ip );
                $ret = false; break;
            case 3:
                $this->setStatus( self::LOGIN_USER_UNKNOWN, $user, $ip );
                $ret = false; break;
        }
        $this->notify();
        return $ret;
    }

    private function setStatus( $status, $user, $ip ) {
        $this->status = array( $status, $user, $ip ); 
    }

    function getStatus() {
        return $this->status;
    }

}

interface Observer {
    function update( Observable $observer );
}

class SecurityMonitor extends Observer {
    function update( Observable $observable ) {
        $status = $observable->getStatus(); 
        if ( $status[0] == Login::LOGIN_WRONG_PASS ) {
            // wylij wiadomo do administratora... 
            print __CLASS__.":\twysyam wiadomo e-mail do administratora\n"; 
        }
    }
}

class GeneralLogger extends Observer {
    function update( Observable $observable ) {
        $status = $observable->getStatus(); 
        // dodaj dane sesji logowania do rejestru...
        print __CLASS__.":\tdodaj wpis do rejestru logowania\n"; 
    }
}

class PartnershipTool extends Observer {
    function update( Observable $observable ) {
        $status = $observable->getStatus(); 
        // sprawd adres IP 
        // jeli adres rozpoznany, ustaw specjalne ciasteczko
        print __CLASS__.":\tustawiam ciasteczko dla rozpoznanego adresu IP\n"; 
    }
}

$login = new Login();
$login->attach( new SecurityMonitor() );
$login->attach( new GeneralLogger() );
$login->attach($pt = new PartnershipTool() );
$login->detach( $pt );
for ( $x=0; $x<1; $x++ ) {
    $login->handleLogin( "bob", "hop123", '158.152.55.35' );
    print "\n";
}

?>
