<?php

abstract class Tile {
    abstract function getWealthFactor();
}

class Plains extends Tile {
    private $wealthfactor = 2;
    function getWealthFactor() {
        return $this->wealthfactor;
    }
}

abstract class TileDecorator extends Tile {
    protected $tile;
    function __construct( Tile $tile ) {
        $this->tile = $tile;    
    }
}

class DiamondDecorator extends TileDecorator {
    function getWealthFactor() {
        return $this->{tile}->getWealthFactor()+2;
    }
}

class PollutionDecorator extends TileDecorator {
    function getWealthFactor() {
        return $this->{tile}->getWealthFactor()-4;
    }
}

$tile = new Plains();
print $tile->getWealthFactor(); // 2
// Plains to komponent, zwraca po prostu 2

$tile = new DiamondDecorator( new Plains );
print $tile->getWealthFactor(); // 4
// DiamondDecorator dysponuje referencj obiektu klasy Plains. Wywouje 
// jego metod getWealthFactor() a do wyniku dodaje wasny wsp. 2

$tile = new PollutionDecorator( new DiamondDecorator( new Plains() ));
print $tile->getWealthFactor(); // 0
// PollutionDecorator dysponuje referencj obiektu klasy DiamondDecorator, ktry
// z kolei posiada referencj obiektu klasy Tile. 
?>
