<?php

abstract class ApptEncoder {
    abstract function encode();
}

class BloggsApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie BloggsCal\n";
    }
}

class MegaApptEncoder extends ApptEncoder {
    function encode() {
        return "Dane spotkania zakodowane w formacie MegaCal\n";
    }
}

class CommsManager {
    const BLOGGS = 1;    
    const MEGA = 2;    
    private $mode = 1;

    function __construct( $mode ) {
        $this->mode = $mode;
    }

    function getHeaderText() {
        switch ( $this->mode ) {
            case ( self::MEGA ):
                return "Nagwek MegaCal\n";
            default:
                return "Nagwek BloggsCal\n";
        }
    }

    function getApptEncoder() {
        switch ( $this->mode ) {
            case ( self::MEGA ):
                return new MegaApptEncoder();                
            default:
                return new BloggsEncoder();                
        }
    }
}

$comms = new CommsManager( CommsManager::MEGA );
$apptEncoder = $comms->getApptEncoder();
print $comms->getHeaderText();
print $apptEncoder->encode();
?>
