<?php
class ShopProduct {
    public $numPages;
    public $playLength;
    public $title;
    public $producerMainName;
    public $producerFirstName;
    public $price;
    
    function __construct(   $title, $firstName, 
                            $mainName, $price, 
                            $numPages=0, $playLength=0 ) { 
        $this->title             = $title;
        $this->producerFirstName = $firstName;
        $this->producerMainName  = $mainName;
        $this->price             = $price;
        $this->numPages          = $numPages;
        $this->playLength        = $playLength;
    }
    
    function getNumberOfPages() {
        return $this->numPages;
    }

    function getPlayLength() {
        return $this->playLength;
    }

    function getProducer() {
        return "{$this->producerFirstName}".
               " {$this->producerMainName}";
    }
}

$product1 = new ShopProduct(    "Moja Antonia", "Willa", "Cather", 59.99, 300 );
$product2 = new ShopProduct(    "Exile on Coldharbour Lane", 
                                "The", "Alabama 3", 25.99, null, 60.33 );

print "Autor:         ".$product1->getProducer()."\n";
print "Liczba stron:  ".$product1->getNumberOfPages()."\n";
print "Wykonawca:     ".$product2->getProducer()."\n";
print "Czas nagrania: ".$product2->getPlayLength()."\n";

// Autor:         Willa Cather
// Liczba stron:  300
// artist:        The Alabama 3
// Czas nagrania: 60.33
?>
