<?php

require_once( "woo/base/Exceptions.php" );
require_once( "woo/mapper.php" );
require_once( "woo/mapper/Mapper.php" );
require_once( "woo/mapper/Collections.php" );
require_once( "woo/domain.php" );

class woo_mapper_EventMapper extends woo_mapper_Mapper 
                             implements woo_domain_EventFinder {

    function __construct() {
        parent::__construct();
        $this->selectAllStmt = self::$DB->prepare( 
                            "SELECT * FROM event");
        $this->selectBySpaceStmt = self::$DB->prepare( 
                            "SELECT * FROM event where space=?");
        $this->selectStmt = self::$DB->prepare( 
                            "SELECT * FROM event WHERE id=?");
        $this->updateStmt = self::$DB->prepare( 
                            "UPDATE event SET start=?, duration=?, name=?, id=? WHERE id=?");
        $this->insertStmt = self::$DB->prepare( 
                            "INSERT into event (start, duration, space, name, id) 
                             values( ?, ?, ?, ?, ?)");
    } 
    
    function doFind( $id ) {
        $result = $this->doStatement( $this->selectStmt, array( $id ) );
        return $this->load( $result ); 
    }

    function findAll( ) {
        $result = $this->doStatement( $this->selectAllStmt, array() );
        return new woo_mapper_EventCollection( $result, $this );
    }

    function findBySpaceId( $s_id ) {
        return new woo_mapper_DeferredEventCollection( 
                    $this, $this->selectBySpaceStmt, array( $s_id ) );
    }

    protected function doLoad( $array ) {
        $obj = new woo_domain_Event( $array['id'] );
        $obj->setstart( $array['start'] );
        $obj->setduration( $array['duration'] );
        $obj->setname( $array['name'] );
        $space_mapper = new woo_mapper_SpaceMapper();
        $space = $space_mapper->find( $array['space'] );
        $obj->setSpace( $space );

        $obj->markClean();
        return $obj;
    }

    protected function targetClass() {
        return "woo_domain_Event";
    }

    protected function doInsert( woo_domain_DomainObject $object ) {
    #   $id = $self->newId();
        $space = $object->getSpace();
        if ( ! $space ) { 
            throw new woo_base_AppException( "nie mona zapisa bez lokalizacji" );
        }

        $values = array( $object->getstart(), $object->getduration(), $space->getId(), $object->getname(), $object->getid() ); 
        print "wstawianie: ";
        print_r($values);
        print "\n\n";
        $this->doStatement( $this->insertStmt, $values );
    #   $object->setId( $id );    
    }
    
    public function newId() {
        return self::$DB->nextId('event');
    }

    function update( woo_domain_DomainObject $object ) {
        $values = array( $object->getstart(), $object->getduration(), $object->getname(), $object->getid(), $object->getId() ); 
        $this->doStatement( $this->updateStmt, $values );
    }

    # wasne
}
