<?php
require_once("DB.php");

abstract class DbException extends Exception {
    protected $pearError;
    function __construct( PEAR_Error $error ) {
        parent::__construct( $error->getMessage(), $error->getCode() );
        $this->pearError = $error;
    }
    
    function getPearError() {
        return $this->pearError;
    }
}

class DbConnectionException extends DbException{ }
class SqlException extends DbException{ }

class Person {
    private $name;
    private $age;
    private $id = 0;
    function __construct( $name, $age ) {
        $this->name = $name;
        $this->age  = $age;
    }

    function setID( $id ) {
        $this->id = $id;
    }

    function getName() {
        return $this->name;
    }
    function getAge() {
        return $this->age;
    }
}

class PersonPersist {
    private $dsn;
    private $db_obj;
    private $fields = array( "name", "age" );

    function __construct( $dsn ) {
        $this->dsn = $dsn;
    }

    public function connect( ) {
        $this->db_obj = DB::connect($this->dsn);
        if ( DB::isError( $db_obj )) {
            throw new DbConnectionException( $db_obj );
        }
    }

    public function insert( Person $person ) {
        if ( empty( $this->db_obj) ) {
            $this->connect();
        }
        $row = array();
        foreach( $this->fields as $fieldname ) {
            $method = "get{$fieldname}";
            $row[$fieldname] = $person->$method(); 
        }
        $row['id'] = $this->db_obj->nextId('persons_sequence');
        $insert_result = 
            $this->db_obj->autoExecute( 
            'persons', $row, DB_AUTOQUERY_INSERT );

        if ( DB::isError( $insert_result )) {
            throw new SqlException( $insert_result );
        }
        $person->setId( $row['id'] );

        return $row['id'];
    }
}

$person = new Person( 'bob', 44 );
try {
    $saver = new PersonPersist( "sqlite://./persons.db" );
    $saver->insert( $person );

} catch ( DbConnectionException $e ) {
    print $e->__toString();

} catch ( SqlException $e ) {
    print $e->__toString();

} catch ( Exception $e ) {
    print $e->__toString();

}
?>
