<?php
require_once( 'woo/controller/ApplicationHelper.php' );
require_once( 'woo/controller/Request.php' );
require_once( 'woo/command/CommandResolver.php' );
require_once( 'woo/controller/AppController.php' );

class woo_controller_Controller {
    private $applicationHelper;

    private function __construct() {}

    static function run() {
        $instance = new woo_controller_Controller();
        $instance->init();
        $instance->handleRequest();
    }

    function init() {
        $this->applicationHelper 
            = woo_controller_ApplicationHelper::instance();
        $this->applicationHelper->init();
    }

    function handleRequest() {
        $request = new woo_controller_Request();
        $app_c = $this->applicationHelper->appController();
        while( $cmd = $app_c->getCommand( $request ) ) {
            $cmd->execute( $request );
        }
        $this->forward( $app_c->getView( $request ) ); 
    }

    function forward( $target ) {
        include( "woo/view/$target.php" );
        exit;
    }
}
?>
