<?php

require_once 'C:\php\PEAR\PHPUnit\Framework.php';

require_once('D:\tlum\kody\Rozdzial7\interfaces\StringSearchable.php');
require_once('D:\tlum\kody\Rozdzial7\classes\Search\String\BoyerMoore.php');

// test class are named after the class they test
// and extend PHPUnit_Framework_TestCase
class ResultCountTest extends PHPUnit_Framework_TestCase
{
    // methods are individual test and start with the string "test"
    public function testNumberOfMatches()
    {
        $poem = <<<POEM
Na tapczanie siedzi le,
nic nie robi cay dzie.

"O, wypraszam to sobie!
Jak to ja nic nie robi?
A kto siedzi na tapczanie?
A kto zjad pierwsze niadanie?
A kto dzisiaj plu i apa?
A kto si w gow podrapa?
A kto dzi zgubi kalosze?
O - o! Prosz!"
POEM;

        // create an instance of the search class
        $bm = new BoyerMoore();

        // execute the search using our algorithm
        $bm->search('kto', $poem);

        // assert that the algorithm found the correct
        // number of substrings in the buffer
        $this->assertEquals(4, $bm->getResultsCount(), 'Obliczona ilo trafie nie jest prawidowa.');
    }
}

?>