<?php
/** 
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @package WebServices
 * @subpackage Accounts
 * @copyright Waferthin Web Works LLC
 * @license http://www.gnu.org/copyleft/gpl.html Freely available under GPL
 */
/** 
 * Klasa <i>Users</i>
 * 
 * Klasa ta zawiera trwale zapisane nazwy kont uytkownikw
 * i hase. Jest to rozwizanie czysto robocze i powinno
 * zosta zaimplementowane z uyciem trwaej i bezpiecznej
 * metody przechowywania.
 *
 * @package WebServices
 * @subpackage Accounts
 * @see Authentication
 * @see Authentication_HardcodedAccounts
 * @author Dirk Merkel <dirk@waferthin.com> 
 * @version 0.6
 * @since r15
 */
class Users
{
    /**
     * trwale zapisane konta uytkownikw
     *
     * @access private
     * @static
     * @var array $accounts tablica asocjacyjna uytkownik => haso
     */
    private static $accounts = array('dirk'        => 'myPass',
                                     'albert'    => 'einstein');
                            
    /**
     * metoda statyczna validate
     *
     * Po przekazaniu do nazwy uytkownika i hasa
     * metoda sprawdza, czy taki uytkownik ma konto
     * i czy poda prawidowe haso.
     *
     * @see Authentication_HardcodedAccounts::login()
     * @access public
     * @static
     * @param string $user account user name
     * @param string $password account password
     * @return boolean
     */
    public static function validate($user, $password)
    {
        return self::$accounts[$user] == $password;
    }
    
    /**
     * "magiczna" metoda __call
     *
     * Metoda ta implementuje tylko "magiczn" wersj metody
     * validate, do ktrej nazwy doczona zostaje nazwa konta
     * biecego uytkownika.
     *
     * @see Authentication_HardcodedAccounts::login()
     * @see validate()
     * @access public
     * @method boolean validate<uytkownik>() validate<uytkownik>(string $password)
     * realizuje walidacj uytkownika
     * @staticvar array $accounts suy do walidacji uytkownikw i hase
     */
    public function __call($name, $arguments)
    {
        if (preg_match("/^validate(.*)$/", $name, $matches) && count($arguments) > 0) {
            return self::validate($matches[1], $arguments[0]);
        }
    }
}

?>
