<?php

class MessageQueue
{
    // nazwy staych pisane duymi literami i rozdzielane
    // podkrelnikami
    const MAX_MESSAGES = 100;

    // sugestwne nazwy waciwoci z zastosowaniem konwencji camelCase
    private    $messageQueue            = array("one\ntwo");
    private    $currentMessageIndex    = -1;

    // metoda ustawiajca waciwo $currentMessageIndex
    public setCurrentMessageIndex($currentMessageIndex)
    {
        $this->currentMessageIndex = (int)$currentMessageIndex;
    }

    // metoda pobierajca waciwo $currentMessageIndex
    public getCurrentMessageIndex()
    {
        return $this->currentMessageIndex;
    }

    // metoda is<Atrybut> zwraca warto logiczn
    public function isQueueFull()
    {
        return count($this->messageQueue) == self::MAX_MESSAGES;
    }
    
    // metoda has<Atrybut> zwraca warto logiczn
    public function hasMessages()
    {
        return (is_array($this->messageQueue) && count($this->messageQueue) > 0);
    }
    
    // nazwa metody sugerujca zadanie, jakie wykonuje
    public function resetQueue()
    {
        $this->messageQueue = null;
    }
    
    // nazwa metody sugerujca zadanie, jakie wykonuje
    public function convertMessagesToHtml()
    {
        // lokalna kopia waciwoci messageQueue
        $myMessages = $this->messageQueue;
        
        // krtka nazwa $i jest dopuszczalna w niewielkich ptlach
        for ($i = 0; $i < sizeof($myMessages); $i++) {
            $myMessages[$i] = nl2br($myMessages[$i]);
        }
        
        return $myMessages;
    }
    
    // ... pozostae metody zarzdzajce kolejk komunikatw ...
}

?>
