<?php

// zastosowanie require_once
require_once('logging/Database/DbLogger.php');

class DbConnector
{
    // obsugiwane bazy danych
    public static $supportedDbVendords = array('mysql',
                                                'oracle',
                                                'mssql');

    // metoda fabryki korzystajca z include_once
    public static function makeDbConnection($dbVendor = 'mysql')
    {
        if (in_array($dbVendor, self::$supportedDbVendords)) {
            
            // tworzy nazw klasy na podstawie nazwy producenta bazy danych
            $className = ucfirst($dbVendor);
            include_once 'database/drivers/' .
                        $className . '.php';
            
            return new $className();
            
        } else {
            
            // nieobsugiwana baza danych -> generuje wyjtek
            throw new Exception('Nieobsugiwana baza danych: ' . $dbVendor);
        }
    }
}

// utworzenie poczenia z baz danych za pomoc metody-fabryki
$dbHandle = MakeAnObject::makeDbConnection();

?>