<?php

// Klasa szkieletu Zend kontrolera dla moduu users
class UsersController extends Zend_Controller_Action
{
    public $log = null;

    // inicjalizacja kontrolera
    public function init()
    {
        // pobranie lokalnej referencji do obiektu dziennika
        $this->log = $this->getInvokeArg('bootstrap')->getResource('log');
    }

    // metoda ta bdzie wywoana jeeli w cigu URL
    // nie zawarto adnej akcji
    public function indexAction()
    {
        // przekierowanie na stron logowania
        $this->_redirect('/users/login');
    }

    public function signupAction()
    {
        // pobranie obiektu dania
        $request = $this->getRequest();
        
        // obsuga tworzenia nowych kont
        if ($request->isPost()) {
            
            // tworzenie egzemplarza obiektu Model_Users
            $users = new Model_Users();

            // pobieranie danych przesanych formularzem
            $record = $request->getParams();
            
            // walidacja danych przed ich wstawieniem
            if ($users->validate($record)) {
            
                // usunicie niepotrzebnych danych
                unset($record['password_again'],
                    $record['Submit'],
                    $record['controller'],
                    $record['action'],
                    $record['module']);
        
                // utworzenie nowego rekordu
                try {
                    $users->insert($record);

                    // komunikat potwierdzajcy utworzenie konta
                    $this->view->message = array('Konto dla ' . $record['email'] . ' zostao zaoone.');
                
                    // wysya e-mail potwierdzajcy
                    $this->sendConfirmationEmail($record['email'],
                                                 $record['first_name'] . ' ' . $record['last_name'],
                                                 'admin@zf.waferthin.com',
                                                 'Admin',
                                                 'Account Created',
                                                 'confirm_email.phtml');
                    
                // co nie wyszo
                } catch (Exception $e) {
                    
                    // odnotowanie problemu w dzienniku ...
                    $this->log->info('Nie mona utworzy nowego konta: ' . $record['email'] . "\nKomunikat bdu: " . $e->getMessage());
                
                    // .. i powiadomienie uytkownika
                    $this->view->message = array('Wystpi bd. Konta ' . $record['email'] . ' nie udao si zaoy.');
                }

            // niepowodzenie walidacji
            } else {

                // przypisanie parametrw z powrotem do widoku
                $this->view->params = $record;

                // przypisanie komunikatu sukcesu/niepowodzenia do widoku
                $this->view->message = $users->message;
            }
        }
    }

    public function loginAction()
    {
        // pobiera obiekt dania
        $request = $this->getRequest();

        // obsuguje danie logowania
        if ($request->isPost()) {

            // tworzy egzemplarz obiektu Model_Users
            $users = new Model_Users();

            // walidacja danych uwierzytelniajcych
            if ($user = $users->login($request->getParam('email'), $request->getParam('password'))) {
                    
                // odnotowanie w dzienniku udanego logowania ...
                $this->log->info('Login success: ' . $request->getParam('email'));

                // ukazanie komunikatu powitalnego
                $this->view->message = array('Witaj, ' . $user['first_name'] . ' ' . $user['last_name'] . '. Zostae poprawnie zalogowany(a).');

            // uwierzytelnienie nie zaakceptowane
            } else {
                    
                // odnotowanie nieudanego logowania w dzienniku
				
                $this->log->info('Nieudana prba logowania: ' . $request->getParam('email'));

                // ... wywietlenie komunikatu bedu
                $this->view->message = array('Twj email i haso nie odpowiadaj aktywnemu kontu uytkownika. Sprbuj ponownie lub <a href="/users/signup">zao konto</a>');

                // przypisanie parametrw z powrotem do widoku
                $this->view->params = $request->getParams();
            }
        }
    }
    
    // wysyanie e-maila z treci generowan przez klas Zend_View
    protected function sendConfirmationEmail($recipientEmail,
                                             $recipientName,
                                             $senderEmail,
                                             $senderName,
                                             $subject,
                                             $emailViewName)
    {
        // tworzenie widoku
        $view = new Zend_View();
        
        // gdzie szuka szablonw
        $view->setScriptPath(APPLICATION_PATH . '/views/scripts/users/');
        
        // przypisuje tablic par klucz-warto jaka ma zosta wygenerowana w widoku
        $info = array(
                        'recipientName' => $recipientName,
                        'recipientEmail' => $recipientEmail
                        );
        $view->assign($info);
        
        // generuje widok
        $message = $view->render($emailViewName);
        
        // tworzy egzemplarz obiektu Zend_Mail
        $mail = new Zend_Mail();
        
        // korzysta z wygodnego interfejsu w celu wysania komunikatu potwierdzajcego
        $mail->setBodyText($message)
            ->setFrom($senderEmail, $senderName)
            ->addTo($recipientEmail, $recipientName)
            ->setSubject($subject)
            ->send();

        // odnotowuje w dzienniku fakt wysana e-maila
        $this->log->info('Wysano szablonowy e-mail  ' . $emailViewName . ' do ' . $recipientEmail);
    }
}