<?php

class Cli_Options
{
    private static $instance    = null;
    private $scriptName            = null;
    private $supportedOptions    = array();
    private $optionValues        = array();
    private $arguments            = array();

    private function __construct($supportedOptions)
    {
        // wymagane dla obsugi getopt()
        if (!function_exists('getopt')) {
            throw new Exception("funkcja getopt() jest niedostpna.");
        }

        $this->setSupportedOptions($supportedOptions);
        $this->processCommandLine();
    }

    public static function getInstance($supportedOptions = array())
    {
        if (self::$instance == null) {
            self::$instance = new Cli_Options($supportedOptions);
        }

        return self::$instance;
    }

    public function setSupportedOptions($supportedOptions)
    {
        if (!is_array($supportedOptions)) {
            throw new Exception("Obsugiwane opcje musz by przesane w formie tablicy.");
        } else {
            $this->supportedOptions = $supportedOptions;
        }
    }
    
    public function getSupportedOptions()
    {
        return $this->supportedOptions;
    }
    
    public function getScriptName()
    {
        return $this->scriptName;
    }
    
    public function getArguments()
    {
        return $this->arguments;
    }
    
    public function getArgument($i = 0)
    {
        return $this->arguments[$i];
    }

    public function processCommandLine($args = null)
    {
        // jeeli nie podano adnych opcji pobierane s globalne
        if ($args === NULL) {
            $args = $GLOBALS['argv'];
        }

        // przetwarzanie opcji
        $opts = getopt(implode('', $this->supportedOptions));

        // zachowanie nazwy skrytpu
        $this->scriptName = array_shift($args);

        // usuwa opcje z tablicy $args
        foreach ($opts as $opt => $arg) {

            $allowed = str_replace(array(':', $opt), '', implode($this->supportedOptions));

            $max = strlen($allowed);

            $key = key(preg_grep("'^-$opt([$allowed]{0,$max}|$arg)$'", $args));

            // przetwarza opcj i zachowuje j
            $this->processOption($args[$key]);

            unset($args[$key]);
        }

        // segreguje klucze tablicy
        $args = array_values($args);
        
        // zachowuje argumenty
        $this->arguments = $args;
    }
    
    protected function processOption($option = '')
    {
        // usuwa mylnik
        if ($option{0} == '-') {
            $option{0} = '';
        }

        // czy opcja ma argument?
        if (strstr($option, ':')) {
            list($key, $value) = explode(':', $option, 2);
            $this->optionValues[$key] = $value;

        } else {
            $this->optionValues[$option] = true;
        }
    }

    public function getOptionValue($option)
    {
        // czy opcja jest obsugiwana?
        if (in_array($option, $this->supportedOptions) || in_array($option . ':', $this->supportedOptions)) {
            return $this->optionValues[$option];
        } else {
            throw new Exception("Podano nieobsugiwan opcj.");
        }
    }
}

?>