<?php

class PhpIni
{
    // initicjalizuje biece rodowisko jako null
    public $environment = null;
    
    // inicjalizuje lokalizacj plikw konfiguracyjnych jako pust tablic
    public $configDirs = array();
    
    // inicjalizuje aktywne ustawienia jako pust tablic
    public $activeSettings = array();
    
    // definiuje ustawienia domylne dla kadego rodowiska zdefiniowanego
    // w tej klasie (mona je potem nadpisywa)	
    public $defaultSettings = array();

    // konstruktor ustawia lokalizacj plikw konfiguracyjnych
    public function __construct(array $configDirs = array())
    {
        if (count($configDirs) > 0) {
            $this->configDirs = $configDirs;
        }
    }
    
    // aplikuje ustawienia dla biecego rodowiska
    // opcjonalnie nadpisuje ustawienia domylne innymi
    public function applySettings(array $customSettings = array())
    {
        // zeruje biece ustawienia
        $this->activeSettings = array();
        
        // pobiera list plikw inicjalizacyjnych
        $iniFiles = $this->getIniFiles();
    
        // inicjalizuje ustawienia domylne
        $this->defaultSettings = array();
        
        // czyta wszystkie pliki ini
        foreach ($iniFiles as $iniFile) {
            // scala wszystkie ustawienia domylne
            $this->defaultSettings = array_merge($this->defaultSettings, parse_ini_file($iniFile, TRUE));
        }

        // scala pliki ini z ustawieniami wasnymi
        $this->activeSettings = array_merge($this->defaultSettings[$this->environment], $customSettings);
        
        // aplikuje ustawienia
        foreach ($this->activeSettings as $directive => $value) {
            ini_set($directive, $value);
        }
    }
    
    // zwraca tablic wszystkich katalogw konfiguracyjnych
    public function getConfigDirs()
    {
        $this->configDirs = $configDirs;
    }
    
    // ustawia za jednym razem tablic katalogw konfiguracyjnych
    public function setConfigDirs(array $configDirs = array())
    {
        return $this->configDirs;
    }
    
    // wstawia katalog na koniec tablicy configDirs
    public function addConfigDir($newConfigDir)
    {
        array_push($this->configDirs, $newConfigDir);
    }
    
    // zwraca bieco ustawione rodowisko
    public function getEnvironment()
    {
        return $this->environment;
    }
    
    // ustawia rodowisko
    public function setEnvironment($environment)
    {
        $this->environment = $environment;
    }
    
    // zwraca ustawienia domylne dla danego rodowiska (lub biecego)
    // generuje wyjtek gdy albo rodowisko albo ustawienie nie istnieje
    public function getDefaultSetting($setting, $environment = null)
    {
        // ustawia biece rodowisko jeeli nie podano adnego innego
        if ($environment === null) {
            $environment = $this->getEnvironment();
        }
        
        // sprawdza czy rodowisko istnieje
        if (!array_key_exists($environment, $this->defaultSettings)) {
            throw new Exception("rodowisko '$environment' nie istnieje.");

        // sprawdza, czy ustawienie istnieje
        } elseif (!array_key_exists($setting, $this->defaultSettings[$environment])) {
            throw new Exception("Nie zdefiniowano ustawienia domylnego '$setting' dla rodowiska '$environment'.");
            
        // zwraca podane ustawienie domylne
        } else {
            return $this->defaultSettings[$environment][$setting];
        }
    }
    
    // zwraca aktualn warto danego ustawienia
    // UWAGA: dziaa wycznie wtedy, gdy ustawienie zostao zaaplikowane przez t klas
    public function getActiveSetting($setting)
    {
        // sprawdza czy ustawienie istnieje
        if (!array_key_exists($setting, $this->activeSettings)) {
            throw new Exception("Ustawienie '$setting' nie zostao zdefiniowane przez klas __CLASS__.");
            
        // zwraca podane ustawienie
        } else {
            return $this->activeSettings[$setting];
        }
    }
    
    // po otrzymaniu wszystkich katalogw z configDirs, metoda ta
    // szuka i zwraca wszystkie pliki z tych katalogw z sufiksem .ini
    public function getIniFiles()
    {
        // inicjalizuje tablic plikw .ini
        $iniFiles = array();
        
        // ptla poprzez katalogi
        foreach ($this->configDirs as $dir) {
            
            if (is_dir($dir)) {

                // otwiera katalog ...
                if ($dirHandle = opendir($dir)) {
                
                    // ... i przechodzi przez zawarte w nim pliki
                    while (($file = readdir($dirHandle)) !== FALSE) {
                
                        // sprawdza rozszerzenie
                        $pathParts = pathinfo($dir . DIRECTORY_SEPARATOR . $file);
                        if ($pathParts['extension'] == 'ini') {
                            
                            // znaleziono plik .ini
                            $iniFiles[] = $dir . DIRECTORY_SEPARATOR . $file;
                        }
                    }
                    closedir($dirHandle);
                }
            }
        }

        return $iniFiles;
    }
}

?>