<?php

require_once('interfaces/Interrogator.php');
require_once('classes/Probe.php');
require_once('classes/ProbeService.php');
require_once('classes/Connection.php');

class ServiceRunner
{
    public $host            = null;
    public $startPort        = null;
    public $endPort            = null;
    protected $connections    = array();
    
    // konstruktor pobiera nazw hosta i zakres portw
    public function __construct($host = 'localhost', $startPort = 0, $endPort = 65535)
    {
        $this->host = $host;
        $this->startPort = $startPort;
        $this->endPort = $endPort;
    }

    // uruchamia skanowanie portw
    public function run()
    {
        // pobiera list adresw IP skojarzonych z hostem
        $ipAddresses = $this->resolveHost($this->host);

        // przechodzi poprzez wszystkie znalezione adresy IP ...
        foreach ($ipAddresses as $ip) {
            
            // ... i przechodzi przez cay zakres portw
            for ($port = $this->startPort; $port <= $this->endPort; $port++) {
            
                $probeService = new ProbeService();
            
                // czy poczenie si powiodo?
                if ($connection = $probeService->probe($ip, $port)) {

                    $this->connections[] = $connection;
                }
            }
        }
    }
    
    // wywietla wyniki skanowania
    public function output()
    {
        echo "Wyniki skanowania hosta $this->host:\n\n";

        foreach ($this->connections as $connection) {

            echo "Host: $connection->ip na porcie $connection->port: ";

            // prbuje dopasowa usug do numeru portu
            if (array_key_exists($connection->port, ProbeService::$serviceName)) {
                echo " port ten jest zwykle przypisany do usugi: " . ProbeService::$serviceName[$port] . "\n";
            } else {
                echo "  nie potrafi przypisa tego portu do adnej usugi.\n";
            }
        }
    }
    
    // szuka adresw IP odpowiadajcych danej nazwie hosta
    protected function resolveHost($host)
    {
        if ($ipAddresses = gethostbynamel($host)) {
            return $ipAddresses;
        } else {
            throw new Exception('Nie udao si znale nazwy hosta ' . $host . '. Sprawd poczenie sieciowe lub poprawno nazwy.');
        }
    }
}

$runner = new ServiceRunner('google.com', 80, 81);
$runner->run();
$runner->output();

?>