<?php
//
// +----------------------------------------------------------------------+
// | PHP wersja 4.0                                                       |
// +----------------------------------------------------------------------+
// | Prawa autorskie (c) 1997-2001 The PHP Group                          |
// +----------------------------------------------------------------------+
// | Niniejszy kod rdowy jest objty licencj jzyka PHP w wersji 2.02,|
// | ktra do pakietu zostaa doczona w postaci pliku LICENSE, a ponadto|
// | jest dostpna na stronie internetowej pod adresem                    |
// | http://www.php.net/license/2_02.txt.                                 |
// | Jeli nie dysponujesz kopi licencji jzyka PHP i nie moesze jej    |
// | pobra ze strony internetowej, wtedy prosz wysa wiadomo pod     |
// | adres license@php.net, dziki czemu zostanie ona natychmiast         |
// | przesana.                                                           |
// +----------------------------------------------------------------------+
// | Autorzy: Sebastian Bergmann <sb@sebastian-bergmann.de>               |
// +----------------------------------------------------------------------+
//
// $Id: Timer.php,v 1.1.1.3 2001/12/14 22:14:03 zarzycki Exp $
//

/**
 * Benchmark::Timer
 * 
 * Przeznaczenie:
 * 
 *     Pomiar czasu wykonywania skryptu, generowanie profili informacyjnych
 * 
 * Przykad:
 * 
 *     $timer = new Benchmark_Timer;
 * 
 *     $timer->start();
 *     $timer->setMarker('Marker 1');
 *     $timer->stop();
 * 
 *     $profiling = $timer->getProfiling();
 * 
 * @autor   Sebastian Bergmann <sb@sebastian-bergmann.de>
 * @wersja  $Revision: 1.1.1.3 $
 * @dostp   publiczny
 */

class Benchmark_Timer {
    /**
     * Zawiera znaczniki
     *
     * @var    array
     * @access public
     */
    var $markers = array();

    /**
     * Ustawia znacznik pocztkowy.
     *
     * @see    setMarker(), stop()
     * @access public
     */
    function start() {
        $this->setMarker('Start');
    }

    /**
     * Set "Stop" marker.
     *
     * @see    setMarker(), start()
     * @access public
     */
    function stop() {
        $this->setMarker('Stop');
    }

    /**
     * Ustawienie znacznika.
     *
     * @param  nazwa ustawianego znacznika
     * @see    start(), stop()
     * @access public
     */
    function setMarker($name) {
        $microtime = explode(' ', microtime());
        $this->markers[$name] = $microtime[1] . substr($microtime[0], 1);
    }

    /**
     * Zwraca czas oddzielajacy dwa znaczniki.
     *
     * @param  string  $start        znacznik pocztkowy, domylnie ustawiony na "Start"
     * @param  string  $end          znacznik kocowy, domylnie ustawiony na "Stop"
     * @return double  $time_elapsed czas oddzielajcy znaczniki $start i $end
     * @access public
     */
    function timeElapsed($start = 'Start', $end = 'Stop') {
        if (extension_loaded('bcmath')) {
            return bcsub($this->markers[$end], $this->markers[$start], 6);
        } else {
            return $this->markers[$end] - $this->markers[$start];
        }
    }

    /**
     * Zwraca informacje dotyczce profili.
     *
     * $profiling[x]['name']  = nazwa znacznika x
     * $profiling[x]['time']  = indeks czasowy znacznika x
     * $profiling[x]['diff']  = czas wykonywania mierzony pomidzy znacznikiem x-1 i 
     * znacznikiem x
     * $profiling[x]['total'] = cakowity czas wykonywania mierzony do znacznika x
     *
     * @return array $profiling
     * @access public
     */
    function getProfiling() {
        $i = 0;
        $total = 0;
        $result = array();
        
        foreach ($this->markers as $marker => $time) {
            if ($marker == 'Start') {
                $diff = '-';
            } else {
                if (extension_loaded('bcmath')) {
                    $diff  = bcsub($time,  $temp, 6);
                    $total = bcadd($total, $diff, 6);
                } else {
                    $diff  = $time - $temp;
                    $total = $total + $diff;
                }
            }
            
            $result[$i]['name']  = $marker;
            $result[$i]['time']  = $time;
            $result[$i]['diff']  = $diff;
            $result[$i]['total'] = $total;
            
            $temp = $time;
            $i++;
        }

        return $result;
    }
}
?>
