<?php # Listing 12.8 - logout.php
// Skrypt pozwalajcy na wylogowanie si ze strony.

// Doczenie pliku konfiguracyjnego obsugujcego bdy, itp.
require_once ('includes/config.inc'); 

// Okrelenie tytuu strony i doczenie nagwka HTML.
$page_title = 'Wylogowanie si';
include_once ('includes/header.html');

// Jeli nie istnieje zmienna first_name, wtedy uytkownik zostanie przekierowany.
if (!isset($_SESSION['first_name'])) {

	header ("Location:  http://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . "/index.php");
	ob_end_clean(); // Usuwanie bufora.
	exit(); // Zakoczenie skryptu.
	
} else { // Wylogowanie uytkownika.

	$_SESSION = array(); // Usunicie zmiennych.
	session_destroy(); // Zamknici sesji.
	setcookie (session_name(), '', time()-300, '/', '', 0); // Usunicie pliku cookie.

}

// Wywietlenie odpowiedniego komunikatu.
echo "<h3>Zostae wylogowany.</h3>";

include ('includes/footer.html'); // Doczenie stopki HTML.
?>