<?php # Listing 18.6 - register.php
// Strona obsługuje rejestrację użytkowników na witrynie.
require('includes/config.inc.php');
$page_title = 'Rejestracja';
include('includes/naglowek.html');

if ($_SERVER['REQUEST_METHOD'] == 'POST') { // obsługujemy formularz

  // potrzebujemy połączenia z bazą danych
  require(MYSQL);

  // usuwamy spacje z danych wejściowych
  $trimmed = array_map('trim', $_POST);

  // zakładamy, że dane nie są poprawne
  $fn = $ln = $e = $p = FALSE;

  // sprawdzamy poprawność imienia
  if (preg_match('/^[A-Z \'.-]{2,20}$/i', $trimmed['first_name'])) {
    $fn = mysqli_real_escape_string($dbc, $trimmed['first_name']);
  } else {
    echo '<p class="error">Proszę podać imię!</p>';
  }

  // sprawdzamy poprawność nazwiska
  if (preg_match('/^[A-Z \'.-]{2,40}$/i', $trimmed['last_name'])) {
    $ln = mysqli_real_escape_string($dbc, $trimmed['last_name']);
  } else {
    echo '<p class="error">Proszę podać nazwisko!</p>';
  }

  // sprawdzamy poprawność adresu e-mail
  if (filter_var($trimmed['email'], FILTER_VALIDATE_EMAIL)) {
    $e = mysqli_real_escape_string($dbc, $trimmed['email']);
  } else {
    echo '<p class="error">Proszę podać poprawny adres e-mail!</p>';
  }

  // sprawdzamy czy podano hasło i czy oba hasła są identyczne
  if (strlen($trimmed['password1']) >= 10) {
    if ($trimmed['password1'] == $trimmed['password2']) {
      $p = password_hash($trimmed['password1'], PASSWORD_DEFAULT);
    } else {
      echo '<p class="error">Za drugim razem wpisałeś inne hasło!</p>';
    }
  } else {
    echo '<p class="error">Proszę podać prawidłowe hasło!</p>';
  }

  if ($fn && $ln && $e && $p) { // jeśli wszystko jest w porządku...

    // upewniany się czy adres e-mail jest dostępny
    $q = "SELECT user_id FROM users WHERE email='$e'";
    $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL $q\n<br>Błąd MySQL: " . mysqli_error($dbc));

    if (mysqli_num_rows($r) == 0) { // e-mail jest dostępny

      // tworzymy kod aktywacyjny
      $a = md5(uniqid(rand(), true));

      // dodajemy użytkownika do bazy
      $q = "INSERT INTO users (email, pass, first_name, last_name, active, registration_date) VALUES ('$e', '$p', '$fn', '$ln', '$a', NOW() )";
      $r = mysqli_query($dbc, $q) or trigger_error("Polecenie SQL $q\n<br>Błąd MySQL: " . mysqli_error($dbc));

      if (mysqli_affected_rows($dbc) == 1) { // jeśli udało się dodać...

        // wysyłamy wiadomość e-mail
        $body = "Dziękujemy za rejestrację na <jakis sajt>. Aby uaktywnić konto, kliknij poniższe łącze:\n\n";
        $body .= BASE_URL . 'activate.php?x=' . urlencode($e) . "&y=$a";
        mail($trimmed['email'], 'Potwierdzenie rejestracji', $body, 'From: admin@jakissajt.pl');

        // kończymy stronę
        echo '<h3>Dziękujemy za zarejestrowanie się! Pod Twój adres została wysłana wiadomość e-mail z potwierdzeniem rejestracji. Kliknij umieszczone w niej łącze, aby uaktywnić swoje konto.</h3>';
        include('includes/stopka.html'); // dołączamy stopkę strony HTML
        exit(); // kończymy wykonywanie skryptu

      } else { // jeśli nie udało się dodać użytkownika...
        echo '<p class="error">Rejestracja nie powiodła się ze względu na błąd systemu. Przepraszamy za niedogodności.</p>';
      }

    } else { // jeśli adres e-mail nie jest dostępny...
      echo '<p class="error">Ten adres e-mail już jest zarejestrowany w bazie. Jeśli zapomniałeś hasła, kliknij łącze z prawej strony, aby Ci je wysłać.</p>';
    }

  } else { // błąd walidacji danych
    echo '<p class="error">Proszę spróbować jeszcze raz.</p>';
  }

  mysqli_close($dbc);

} // koniec głównej instrukcji warunkowej
?>

<h1>Rejestracja</h1>
<form action="register.php" method="post">
  <fieldset>

  <p><strong>Imię:</strong> <input type="text" name="first_name" size="20" maxlength="20" value="<?php if (isset($trimmed['first_name'])) echo $trimmed['first_name']; ?>"></p>

  <p><strong>Nazwisko:</strong> <input type="text" name="last_name" size="20" maxlength="40" value="<?php if (isset($trimmed['last_name'])) echo $trimmed['last_name']; ?>"></p>

  <p><strong>Adres e-mail:</strong> <input type="email" name="email" size="30" maxlength="60" value="<?php if (isset($trimmed['email'])) echo $trimmed['email']; ?>"> </p>

  <p><strong>Hasło:</strong> <input type="password" name="password1" size="20" value="<?php if (isset($trimmed['password1'])) echo $trimmed['password1']; ?>"> <small>musi mieć co najmniej 10 znaków długości.</small></p>

  <p><strong>Powtórz hasło:</strong> <input type="password" name="password2" size="20" value="<?php if (isset($trimmed['password2'])) echo $trimmed['password2']; ?>"></p>
  </fieldset>

  <div align="center"><input type="submit" name="submit" value="Rejestracja"></div>

</form>

<?php include('includes/stopka.html'); ?>