<?php # Listing 17.7 - post.php
// Ten skrypt obsługiuje dodawanie wiadomości do formu.
// W razie tworzenia nowego wątku, wyświetla także formularz.
include('includes/naglowek.html');

if ($_SERVER['REQUEST_METHOD'] == 'POST') { // obsługujemy formularz

  // W sesji jest dostępny identyfikator języka.
  // sprawdzamy identyfikator wątku ($tid), który może nie być dostępny
  if (isset($_POST['tid']) && filter_var($_POST['tid'], FILTER_VALIDATE_INT, array('min_range' => 1)) ) {
    $tid = $_POST['tid'];
  } else {
    $tid = FALSE;
  }

  // jeśli nie ma identyfikatora wątku, trzeba będzie podać temat
  if (!$tid && empty($_POST['subject'])) {
    $subject = FALSE;
    echo '<p class="bg-danger">Proszę podać temat wiadomości.</p>';
  } elseif (!$tid && !empty($_POST['subject'])) {
    $subject = htmlspecialchars(strip_tags($_POST['subject']));
  } else { // jest dostępny identyfikator wątku, podawanie tematu niepotrzebne
    $subject = TRUE;
  }

  // sprawdzamy treść wiadomości
  if (!empty($_POST['body'])) {
    $body = htmlentities($_POST['body']);
  } else {
    $body = FALSE;
    echo '<p class="bg-danger">Proszę podać treść wiadomości.</p>';
  }

  if ($subject && $body) { // OK!

    // dodajemy wiadomość do bazy danych

    if (!$tid) { // tworzymy nowy wątek
      $q = "INSERT INTO threads (lang_id, user_id, subject) VALUES ({$_SESSION['lid']}, {$_SESSION['user_id']}, '" . mysqli_real_escape_string($dbc, $subject) . "')";
      $r = mysqli_query($dbc, $q);
      if (mysqli_affected_rows($dbc) == 1) {
        $tid = mysqli_insert_id($dbc);
      } else {
        echo '<p class="bg-danger">Wiadomość nie została obsłużona ze względu na błąd systemu.</p>';
      }
    } // brak $tid

    if ($tid) { // dodajemy wiadomość do tabeli odpowiedzi
      $q = "INSERT INTO posts (thread_id, user_id, message, posted_on) VALUES ($tid, {$_SESSION['user_id']}, '" . mysqli_real_escape_string($dbc, $body) . "', UTC_TIMESTAMP())";
      $r = mysqli_query($dbc, $q);
      if (mysqli_affected_rows($dbc) == 1) {
        echo '<p class="bg-success">Wiadomość została zapisana.</p>';
      } else {
        echo '<p class="bg-danger">Wiadomość nie została obsłużona ze względu na błąd systemu.</p>';
      }
    } // prawidłowa wartość $tid.

  } else { // dołączamy formularz
    include('includes/post_form.php');
  }

} else { // wyświetlamy formularz

  include('includes/post_form.php');

}

include('includes/stopka.html');
?>