<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Testowanie wyrażeń PCRE</title>
</head>
<body>
<?php # Listing 14.3 - zastepowanie.php
// Skrypt sprawdzający dopasowanie wzorca i łańcucha wprowadzonych przez użytkownika.
// Ta wersja skryptu zastępuje jeden łańcuch innym.

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // usuwamy zbędne odstępy
  $pattern = trim($_POST['pattern']);
  $subject = trim($_POST['subject']);
  $replace = trim($_POST['replace']);

  // wyświetlamy nagłówek
  echo "<p>Wynik zastąpienia wzorca<br><strong>$pattern</strong><br>łańcuchem<br>$replace<br>w łańcuchu<br>$subject<br><br>";

  // testujemy dopasowanie
  if (preg_match($pattern, $subject) ) {
    echo preg_replace($pattern, $replace, $subject) . '</p>';
  } else {
    echo 'Wzorzec nie został znaleziony!</p>';
  }

} // koniec instrukcji IF
// wyśietlamy formularz HTML
?>
<form action="zastepowanie.php" method="post">
  <p>Wzorzec wyrażenia regularnego: <input type="text" name="pattern" value="<?php if (isset($pattern)) echo htmlentities($pattern); ?>" size="40"> (razem z ogranicznikami)</p>
  <p>Łańcuch zastępujący: <input type="text" name="replace" value="<?php if (isset($replace)) echo htmlentities($replace); ?>" size="40"></p>
  <p>Sprawdzany łańcuch: <textarea name="subject" rows="5" cols="40"><?php if (isset($subject)) echo htmlentities($subject); ?></textarea></p>
  <input type="submit" name="submit" value="Test!">
</form>
</body>
</html>