<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Kontakt</title>
</head>
<body>
<h1>Kontakt</h1>
<?php # Listing 13.1 - email.php #2
// Ta wersja skryptu usuwa z danych wysyłanych mailem wszystkie niebezpieczne łańcuchy znaków.

// sprawdzamy, czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  /* Ta funkcja ma jeden argument: łańcuch znaków.
   * Zwraca "bezpieczną" wersję łańcucha.
   * Może nią być także pusty łańcuch lub łańcuch wejściowy
   * z którego usnięto wszystkie znaki nowego wiersza.
   */
  function spam_scrubber($value) {

    // lista niedozwolonych łańcuchów:
    $very_bad = ['to:', 'cc:', 'bcc:', 'content-type:', 'mime-version:', 'multipart-mixed:', 'content-transfer-encoding:'];

    // jeśli łańcuch wejściowy zawiera którykolwiek z niedozwolonych 
    // łańcuchów, to funkcja zwraca pusty łańcuch
    foreach ($very_bad as $v) {
      if (stripos($value, $v) !== false) return '';
    }

    // zastępujemy znaki nowego wiersza znakami odstępu
    $value = str_replace(["\r", "\n", "%0a", "%0d"], ' ', $value);

    // zwracamy wynik
    return trim($value);

  } // koniec funkcji spam_scrubber()

  // czyścimy dane formularza
  $scrubbed = array_map('spam_scrubber', $_POST);

  // podstawowe kontrola poprawności danych wejściwych
  if (!empty($scrubbed['name']) && !empty($scrubbed['email']) && !empty($scrubbed['comments']) ) {

    // tworzymy ciało wiadomości
    $body = "Imię i nazwisko: {$scrubbed['name']}\n\nUwagi: {$scrubbed['comments']}";

    // ciało wiadomości może mieć co najwyżej 70 znaków długości
    $body = wordwrap($body, 70);

    // wysyłamy wiadomość
    mail('twoj_email@jakissajt.pl', 'Z formularza kontaktowego', $body, "From: {$scrubbed['email']}");

    // wyświetlamy wiadomość
    echo '<p><em>Dziękuję za przesłanie uwag. Może kiedyś odpiszę.</em></p>';

    // czyścimy tablicę $scrubbed (tak by wartości nie były dostępne na następnej stronie):
    $scrubbed = [];

  } else {
    echo '<p style="font-weight: bold; color: #C00">Proszę wypełnić wszystkie pola formularza.</p>';
  }

} // koniec głównej instrukcji IF isset()

// generujemy formularz HTML
?>
<p>Wypełnij poniższy formularz, aby się ze mną skontaktowć.</p>
<form action="email.php" method="post">
  <p>Personalia: <input type="text" name="name" size="30" maxlength="60" value="<?php if (isset($scrubbed['name'])) echo $scrubbed['name']; ?>"></p>
  <p>Adres e-mail: <input type="email" name="email" size="30" maxlength="80" value="<?php if (isset($scrubbed['email'])) echo $scrubbed['email']; ?>"></p>
  <p>Uwagi: <textarea name="comments" rows="5" cols="30"><?php if (isset($scrubbed['comments'])) echo $scrubbed['comments']; ?></textarea></p>
  <p><input type="submit" name="submit" value="Wyślij!"></p>
</form>
</body>
</html>