<?php # Listing 12.3 - login.php
// Skrypt obsługujący formularz logowania.
// Po pomyślnym zalogowaniu, użytkownik zostaje przekierowany na stronę loggedin.php
// Strona dołącza dwa pliki.
// Nie wysyłaj NICZEGO do przeglądarki przed wywołaniem funkcji setcookie()!

// sprawdzamy czy formularz został przesłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // dołączamy funkcje obsługujące logowanie
  require('includes/login_functions.inc.php');

  // używamy połączenia z bazą danych
  require('../mysqli_connect.php');

  // próbujemy zalogować użytkownika
  list($check, $data) = check_login($dbc, $_POST['email'], $_POST['pass']);

  if ($check) { // OK!

    // tworzymy ciasteczka
    setcookie('user_id', $data['user_id']);
    setcookie('first_name', $data['first_name']);

    // przekierowanie
    redirect_user('loggedin.php');

  } else { // niepowodzenie

    // zapisujemy $data w zmiennej $errors aby zwrócić informacje
    // o błędzie w pliku login_page.inc.php.
    $errors = $data;

  }

  mysqli_close($dbc); // zamykamy połączenie z bazą danych

} // koniec głównej instrukcji warunkowej

// tworzymy stronę
include('includes/login_page.inc.php');
?>