<?php # Skrypt 10.1 - pokaz_uzytkownikow.php #3
// Pobiera wszystkie rekordy z tabeli users.
// Nowa wersja zawierająca łącza do stron edycji i usuwania.

$page_title = 'Zobacz zarejestrowanych użytkowników';
include ('includes/naglowek.html');
echo '<h1>Zarejestrowani użytkownicy</h1>';

require('../mysqli_connect.php');
    
// tworzymy zapytanie
$q = "SELECT last_name, first_name, DATE_FORMAT(registration_date, '%d %M %Y') AS dr, user_id FROM users ORDER BY registration_date ASC";    
$r = @mysqli_query ($dbc, $q); // wykonujemy zapytanie

// określamy liczbę zwróconych rekordów
$num = mysqli_num_rows($r);

if ($num > 0) { // jeżeli zapytanie zwróciło jakieś rekordy, to je wyświetlamy

  // wyświetlamy liczbę użytkowników
  echo "<p>Obecnie zarejestrowanych jest $num użytkowników.</p>\n";

  // wyświetlamy nagłówek tabeli
  echo '<table width="60%">
  <thead>
  <tr>
    <th align="left"><strong>Edytuj</strong></th>
    <th align="left"><strong>Usuń</strong></th>
    <th align="left"><strong>Nazwisko</strong></th>
    <th align="left"><strong>Imię</strong></th>
    <th align="left"><strong>Data rejestracji</strong></th>
  </tr>
  </thead>
  <tbody>
  ';
  
  // pobieramy i wyświetlamy wszystkie rekordy
  while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {
    echo '<tr>
      <td align="left"><a href="edytuj_uzytkownika.php?id=' . $row['user_id'] . '">Edytuj</a></td>
      <td align="left"><a href="usun_uzytkownika.php?id=' . $row['user_id'] . '">Usuń</a></td>
      <td align="left">' . $row['last_name'] . '</td>
      <td align="left">' . $row['first_name'] . '</td>
      <td align="left">' . $row['dr'] . '</td>
    </tr>
    ';
  }

  echo '</tbody></table>';  // zamykamy tabelę
  mysqli_free_result ($r);  // zwalniamy zasoby

} else { // jeżeli zapytanie nie zostało wykonane pomyślnie...
  echo '<p class="error">Brak zarejestrowanych użytkowników.</p>';
}

mysqli_close($dbc);

include ('includes/stopka.html');
?>