<?php # Listing 17.4 - forum.php
// Ta strona służy do wyświetlania wątków na forum.
include('includes/naglowek.html');

// pobieramy wszystkie wiadomości w tym forum...

// Jeśli użytkownik jest zalogowany i została wybrana strefa czasowa,
// to używamy jej do skonwertowania daty i czasu.
if (isset($_SESSION['user_tz'])) {
  $first = "CONVERT_TZ(p.posted_on, 'UTC', '{$_SESSION['user_tz']}')";
  $last = "CONVERT_TZ(p.posted_on, 'UTC', '{$_SESSION['user_tz']}')";
} else {
  $first = 'p.posted_on';
  $last = 'p.posted_on';
}

// To zapytanie służy do pobierania wszystkich wątków z forum, wraz z autorem, 
// liczbą odpowiedzi, datą rozpoczęcia wątku oraz datą ostatniej odpowiedzi.
$q = "SELECT t.thread_id, t.subject, username, COUNT(post_id) - 1 AS responses, MAX(DATE_FORMAT($last, '%e-%b-%y %l:%i %p')) AS last, MIN(DATE_FORMAT($first, '%e-%b-%y %l:%i %p')) AS first FROM threads AS t INNER JOIN posts AS p USING (thread_id) INNER JOIN users AS u ON t.user_id = u.user_id WHERE t.lang_id = {$_SESSION['lid']} GROUP BY (p.thread_id) ORDER BY last DESC";
$r = mysqli_query($dbc, $q);
if (mysqli_num_rows($r) > 0) {

  // tworzymy tabelę
  echo '<table class="table table-striped">
  <thead>
    <tr>
      <th>' . $words['subject'] . '</th>
      <th>' . $words['posted_by'] . '</th>
      <th>' . $words['posted_on'] . '</th>
      <th>' . $words['replies'] . '</th>
      <th>' . $words['latest_reply'] . '</th>
    </tr>
  </thead>
  <tbody>';

  // pobieramy każdy wątek
  while ($row = mysqli_fetch_array($r, MYSQLI_ASSOC)) {

    echo '<tr>
        <td><a href="read.php?tid=' . $row['thread_id'] . '">' . $row['subject'] . '</a></td>
        <td>' . $row['username'] . '</td>
        <td>' . $row['first'] . '</td>
        <td>' . $row['responses'] . '</td>
        <td>' . $row['last'] . '</td>
      </tr>';

  }

  echo '</tbody></table>'; // kończymy kod tabeli

} else {
  echo '<p>To forum na razie nie zawiera żadnych wiadomości.</p>';
}

// dołączamy plik stopki
include('includes/stopka.html');
?>