// Listing 15.10 - login.js
// Ten skrypt jest dołączany do strony logowanie.php
// Skrypt obsługuje logowanie i sprawdza poprawność danych,
// a następnie generuje żądanie Ajax do skryptu logowanie_ajax.php.

// wykonujemy operacje po zakończeniu wczytywania dokumentu
$(function() {
  
  // ukrywamy wszystkie komunikaty o błędach
  $('.errorMessage').hide();
  
  // ustawiamy procedurę obsługi przesłania formularza
  $('#login').submit(function() {
    
    // inicjujemy zmienne
    var email, password;
    
    // sprawdzamy adres e-mail
    if ($('#email').val().length >= 6) {
  
      // pobieramy wpisany adres
      email = $('#email').val();
  
      // czyścimy błąd, jeśli istnieje
      $('#emailP').removeClass('error');

      // ukrywamy komunikat o błędzie, jeśli jest widoczny
      $('#emailError').hide();
      
    } else { // nieprawidłowy adres e-mail!
  
      // dodajemy klasę błędu
      $('#emailP').addClass('error');

      // wyświetlamy komunikat o błędzie
      $('#emailError').show();

    }
    
    // sprawdzamy poprawność hasła
    if ($('#password').val().length > 0) {
      password = $('#password').val();
      $('#passwordP').removeClass('error');
      $('#passwordError').hide();
    } else {
      $('#passwordP').addClass('error');
      $('#passwordError').show();
    }
        
    // jeśli dane są poprawne wykonujemy żądanie Ajax
    if (email && password) {
  
      // tworzymy obiekt na dane
      var data = new Object();
      data.email = email;
      data.password = password;
      
      // tworzymy obiekt na opcje żądania Ajax
      var options = new Object();

      // ustawiamy opcje żądania
      options.data = data;
      options.dataType = 'text';
      options.type = 'get';
      options.success = function(response) {
        
        // jeśli logowanie udane
        if (response == 'CORRECT') {
  
          // ukrywamy formularz
          $('#login').hide();
  
          // wyświetlamy komuniakt
          $('#results').removeClass('error');
          $('#results').text('Teraz jesteś zalogowany!');
          
        } else if (response == 'INCORRECT') {
          $('#results').text('Przekazane dane uwierzytelniające nie są poprawne!');
          $('#results').addClass('error');
        } else if (response == 'INCOMPLETE') {
          $('#results').text('Wprowadź adres e-mail i hasło!');
          $('#results').addClass('error');
        } else if (response == 'INVALID_EMAIL') {         
          $('#results').text('Wprowadź poprawny adres e-mail!');
          $('#results').addClass('error');
        }
        
      }; // koniec prawidłowej obsługi żądania
      options.url = 'logowanie_ajax.php';

      // wykonujemy żądanie
      $.ajax(options);
    
    } // koniec instrukcj IF email && password
    
    // zwracamy false, by zapobiec przesłaniu żądania na serwer w tradycyjny sposób
    return false;
    
  }); // koniec obsługi przesyłania formularza

}); // koniec funkcji ready