<?php # Listing 18.3 - config.inc.php
/* This script:
 * - definiuje stałe i ustawienia konfiguracyjne witryny
 * - określa sposób obsługi błędów
 * - definiuje funkcje używane przez witrynę
 */

// Tutaj udokumentuj kto, kiedy i w jakim celu stworzył tę witrynę.


// ************************************ //
// ************ USTAWIENIA ************ //

// znacznik statusu witryny
define('LIVE', FALSE);

// adres administratora
define('EMAIL', 'InsertRealAddressHere');

// adres URL witryny (używany do przekierowań)
define('BASE_URL', 'http://www.jakissajt.pl/');

// położenie skryptu nawiązującego połączenie z serwere SQL
define('MYSQL', '/ścieżka/do/mysqli_connect.php');

// konfiguracja strfy czasowej (dla PHP 5.1 i nowyszych)
date_default_timezone_set('Europe/Warsaw');

// ************ USTAWIENIA ************ //
// ************************************ //


// **************************************** //
// ************ OBSŁUGA BŁĘDÓW ************ //
 
// Funkcja do obsługi błędów
function my_error_handler($e_number, $e_message, $e_file, $e_line, $e_vars) {

  // tworzymy komunikat o błędzie
  $message = "<p>W $e_line. wierszu skryptu '$e_file' wystąpił błąd: $e_message\n";

  // dodajemy do niego datę i czas
  $message .= "Date/czas: " . date('n-j-Y H:i:s') . "\n";

  if (!LIVE) { // faza tworzenia witryny (wyświetlamy komunikat o błędzie)

    // wyświetlamy komunikat
    echo '<div class="error">' . nl2br($message);

    // dodajemy zmienne i zrzut stosu
    echo '<pre>' . print_r ($e_vars, 1) . "\n";
    debug_print_backtrace();
    echo '</pre></div>';

} else { // nie wyświetlamy komunikatu o błędzie

  // wysyłamy email do administratora
  $body = $message . "\n" . print_r ($e_vars, 1);
  mail(EMAIL, 'Błąd na witrynie!', $body, 'From: email@jakissajt.pl');

  // komunikat wyświetlamy jedynie gdy błąd nie należy do klasy E_NOTICE
  if ($e_number != E_NOTICE) {
    echo '<div class="error">Wystąpił błąd systemu. Przepraszamy za niedogodności.</div><br>';
  }
} // koniec instrukcji IF !LIVE 

} // koniec definicji funkcji my_error_handler().

// używamy funkcji  my_error_handler() do obsługi błędów
set_error_handler('my_error_handler');

// ************ OBSŁUGA BŁĘDÓW ************ //
// **************************************** //