<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Testowanie wyrażeń PCRE</title>
</head>
<body>
<?php # Listing 14.2 - dopasowania.php
// Skrypt sprawdzający dopasowanie wzorca i łańcucha wprowadzonych przez użytkownika.
// Ta wersja wyświetla wszystkie dopasowania.

if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // usuwamy zbędne odstępy
  $pattern = trim($_POST['pattern']);
  $subject = trim($_POST['subject']);

  // wyświetlamy nagłówek
  echo "<p>Wynik zastosowania wzorca<br><strong>$pattern</strong><br>do łańcucha<br>$subject<br>to ";

  // testujemy dopasowanie
  if (preg_match_all($pattern, $subject, $matches) ) {
    echo 'TRUE!</p>';

    // wyświetlamy dopasowania
    echo '<pre>' . print_r($matches, 1) . '</pre>';

  } else {
    echo 'BRAK DOPASOWANIA!</p>';
  }

} // koniec instrukcji IF
// wyśietlamy formularz HTML
?>
<form action="dopasowania.php" method="post">
  <p>Wzorzec wyrażenia regularnego: <input type="text" name="pattern" value="<?php if (isset($pattern)) echo htmlentities($pattern); ?>" size="40"> (wraz z ogranicznikami)</p>
  <p>Sprawdzany łańcuch: <textarea name="subject" rows="5" cols="40"><?php if (isset($subject)) echo htmlentities($subject); ?></textarea></p>
  <input type="submit" name="submit" value="Testuj!">
</form>
</body>
</html>