<!doctype html>
<html lang="pl">
<head>
  <meta charset="utf-8">
  <title>Kalkulator sprzedaży</title>
</head>
<body>
<?php # Listing 13.2 - kalkulator.php
// Skrypt oblicza całkowit koszt zamówienia na podstawie wartości trzech pól formularza.

// sprawdzamy czy formularz został wysłany
if ($_SERVER['REQUEST_METHOD'] == 'POST') {

  // rzutujemy wszystkie zmienne na odpowiedni typ
  $quantity = (int) $_POST['quantity'];
  $price = (float) $_POST['price'];
  $tax = (float) $_POST['tax'];

  // wartości wszystkich zmiennych powinny być dodatnie
  if ( ($quantity > 0) && ($price > 0) && ($tax > 0) ) {

    // obliczamy łączny koszt
    $total = $quantity * $price;
    $total += $total * ($tax/100);

    // wyświetlamy wyniki
    echo '<p>Kupujesz ' . $quantity . ' sztuk w cenie ' . number_format($price, 2) . ' za każdą, po uwzględnieniu podatku daje to koszt' . number_format($total, 2) . ' zł.</p>';

  } else { // wartości przesłane z formularza są nieprawidłowe
    echo '<p style="font-weight: bold; color: #C00">Wprowadź poprawną liczbę egzemplarzy, cenę oraz podatek.</p>';
  }

} // koniec instrukcji IF isset()

// koniec sekcji PHP i początek formularza HTML
?>
<h2>Kalkulator sprzedaży</h2>
<form action="kalkulator.php" method="post">
  <p>Liczba egzemplarzy: <input type="number" name="quantity" step="1" min="1" value="<?php if (isset($quantity)) echo $quantity; ?>"></p>
  <p>Cena: <input type="number" name="price" step=".01" min="0.01" value="<?php if (isset($price)) echo $price; ?>"></p>
  <p>Podatek (%): <input type="text" name="tax" step=".01" min="0.01" value="<?php if (isset($tax)) echo $tax; ?>"></p>
  <p><input type="submit" name="submit" value="Oblicz!"></p>
</form>
</body>
</html>