<?php # Skrypt 14.6 - browse_prints.php
// Ta strona wywietla dostpne odbitki (produkty).

// Ustawiamy tytu strony i doczamy nagwek HTML.
$page_title = 'Przegldanie odbitek';
include ('./includes/header.html');

require_once ('../mysql_connect.php'); // czymy si z baz danych.

// Czy szukamy konkretnego artysty?
if (isset($_GET['aid'])) {
  $aid = (int) $_GET['aid'];
  if ($aid > 0) {
    $query = "SELECT artists.artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS name, print_name, price, description, print_id FROM artists, prints WHERE artists.artist_id = prints.artist_id AND prints.artist_id =$aid ORDER BY prints.print_name";
  } else {
    $query = "SELECT artists.artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS name, print_name, price, description, print_id FROM artists, prints WHERE artists.artist_id = prints.artist_id ORDER BY artists.last_name ASC, prints.print_name ASC";
  }
} else {
  $query = "SELECT artists.artist_id, CONCAT_WS(' ', first_name, middle_name, last_name) AS name, print_name, price, description, print_id FROM artists, prints WHERE artists.artist_id = prints.artist_id ORDER BY artists.last_name ASC, prints.print_name ASC";
}

// Tworzymy nagwek tabeli.
echo '<table border="0" width="90%" cellspacing="3" cellpadding="3" align="center">
<tr>
<td align="left" width="20%"><b>Artysta</b></td>
<td align="left" width="20%"><b>Nazwa odbitki</b></td>
<td align="left" width="40%"><b>Opis</b></td>
<td align="right" width="20%"><b>Cena</b></td>
</tr>';

// Wywietlamy wszystkie odbitki wraz z czami URL.
$result = mysqli_query ($dbc, $query);
while ($row = mysqli_fetch_array ($result, MYSQL_ASSOC)) {

  // Wywietlamy kady rekord.
  echo "  <tr>
    <td align=\"left\"><a href=\"browse_prints.php?aid={$row['artist_id']}\">{$row['name']}</a></td>
    <td align=\"left\"><a href=\"view_print.php?pid={$row['print_id']}\">{$row['print_name']}</td>
    <td align=\"left\">{$row['description']}</td>
    <td align=\"right\">" . number_format($row['price'], 2, ',', ' ') . " z </td>
  </tr>\n";
  
} // Koniec ptli while.

echo '</table>'; // Zamykamy tabel.

mysqli_close($dbc); // Zamykamy poczenie z baz danych.
include ('./includes/footer.html');
?>
