<?php # Skrypt 14.11 - submit_order.php
// Ta strona wstawia informacje o zamwieniu do tabeli bazy danych.
// Strona ta byaby wywietlana po obcieniu rachunku klienta.
// Zakadamy, e proces fakturowania zakoczy si powodzeniem (otrzymalimy pienidze).

// Ustawiamy tytu strony i doczamy nagwek HTML.
$page_title = 'Potwierdzenie zamwienia';
include ('./includes/header.html');

// Zakadamy, e klient jest zalogowany i e strona ma dostp do jego identyfikatora.
$customer = 1; // Tymczasowe.

// Zakadamy, e strona otrzymaa czn kwot zamwienia.
$total = 178.93; // Tymczasowe.

require_once ('../mysql_connect.php'); // czymy si z baz danych.

// Wyczamy automatyczne zatwierdzanie.
mysqli_autocommit($dbc, FALSE);

// Dodajemy zamwienie do tabeli zamwie.
$query = "INSERT INTO orders (customer_id, total) VALUES ($customer, $total)";
$result = mysqli_query($dbc, $query);
if (mysqli_affected_rows($dbc) == 1) {

  // Potrzebujemy identyfikatora zamwienia.
  $oid = mysqli_insert_id($dbc);
  
  // Wstawiamy zawarto zamwienia do bazy danych.
  $query = "INSERT INTO order_contents (order_id, print_id, quantity, price) VALUES ";
  foreach ($_SESSION['cart'] as $pid => $value) {
    $query .= "($oid, $pid, {$value['quantity']}, {$value['price']}), ";
  }
  $query = substr($query, 0, -2); // Odcinamy dwa ostatnie znaki.
  $result = mysqli_query($dbc, $query);
  
  // Zgaszamy wynik operacji.
  if (mysqli_affected_rows($dbc) == count($_SESSION['cart'])) { // Hoho!
  
    // Zatwierdzamy transakcj.
    mysqli_commit($dbc);
    mysqli_close($dbc);
    
    // Usuwamy zawarto koszyka.
    unset($_SESSION['cart']);
    
    // Komunikat dla klienta.
    echo '<p>Dzikujemy za zoenie zamwienia. Zostaniesz poinformowany o wysyce towaru.</p>';
    
    // Tu mona wysa wiadomo e-mail itd.
  
  } else { // Wycofujemy transakcj i zgaszamy problem.
  
    mysqli_rollback($dbc);
    mysqli_close($dbc);
    
    echo '<p>Nie udao si przetworzy zamwienia ze wzgldu na bd systemu. Nasz pracownik skontaktuje si z Tob w celu rozwizania problemu. Przepraszamy za niedogodno.</p>';
    // Tu naley wysa informacje o zamwieniu do administratora.
    
  }

} else { // Wycofujemy transakcj i zgaszamy problem.

  mysqli_rollback($dbc);
  mysqli_close($dbc);

  echo '<p>Nie udao si przetworzy zamwienia ze wzgldu na bd systemu. Nasz pracownik skontaktuje si z Tob w celu rozwizania problemu. Przepraszamy za niedogodno.</p>';
  // Tu naley wysa informacje o zamwieniu do administratora.
  
}

include ('./includes/footer.html');
?>
