<?php # Skrypt 13.3 - config.inc.php

// Ten skrypt definiuje sposb obsugi bdw.

// Zmienna znacznikowa okrelajca stan witryny.
$live = FALSE;

// Adres e-mail, pod ktry bd wysyane komunikaty o bdach.
$email = 'TutajWstawiPrawdziwyAdres';

// Procedura obsugi bdw.
function my_error_handler ($e_number, $e_message, $e_file, $e_line, $e_vars) {

	global $live, $email;

	// Budujemy komunikat o bdzie.
	$message = "W $e_line. wierszu skryptu '$e_file' wystpi bd:\n<br />$e_message\n<br />";
	
	// Dodajemy dat i czas.
	$message .= "Data i czas: " . date('n-j-Y H:i:s') . "\n<br />";
	
	// Doczamy do komunikatu zawarto zmiennej $e_vars.
	$message .= "<pre>" . print_r ($e_vars, 1) . "</pre>\n<br />";
	
	if ($live) { // Nie pokazujemy szczegowego komunikatu o bdzie.
	
		error_log ($message, 1, $email); // Wysyamy wiadomo e-mail.
		
		// Oglny komunikat o bdzie wywietlamy tylko wtedy, gdy bd nie jest powiadomieniem.
		if ($e_number != E_NOTICE) {
			echo '<div id="Error">Wystpi bd systemowy. Przepraszamy za niedogodno.</div><br />';
		}
		
	} else { // Faza projektowa (wywietlamy szczegowy komunikat).
		echo '<div id="Error">' . $message . '</div><br />';
	}

} // Koniec funkcji my_error_handler().

// Uaktywniamy procedur obsugi bdw.
set_error_handler ('my_error_handler');
?>