﻿<?php # Listing 12.7 - edit_url.php
// Ta strona pozwala użytkownikom edytować lub usuwać istniejące rekordy URL.

// Ustawienie tytułu strony i dołączenie nagłówka HTML.
$page_title = 'Edycja adresów URL';
include ('./includes/header.html');

// Sprawdzenie identyfikatora adresu URL.
if (isset($_GET['uid'])) { // Strona jest wyświetlana po raz pierwszy.
    $uid = (int) $_GET['uid'];
} elseif (isset($_POST['uid'])) { // Formularz został przesłany.
    $uid = (int) $_POST['uid'];
} else { // Poważny problem!
    $uid = 0;
}

if ($uid <= 0) { // Nie kontynuować!
    echo '<p><font color="red">Nieprawidłowy dostęp do strony!</font></p>';
    include ('./includes/footer.html');
    exit(); // Zakończenie wykonywania skryptu.
}

require_once ('../mysql_connect.php'); // Nawiązanie połączenia z bazą danych.

if (isset($_POST['submitted'])) { // Obsługa formularza.

    // Dwa wątki: usunąć rekord LUB zmodyfikować go.

    if ($_POST['which'] == 'delete') { // Usunąć rekord.
    
        // Usuwanie rekordu z tabeli urls.
        $query = "DELETE FROM urls WHERE url_id=$uid";
        $result = mysql_query($query);
        $affect = mysql_affected_rows();
        
        // Usuwanie rekordu z tabeli url_associations.
        $query = "DELETE FROM url_associations WHERE url_id=$uid";
        $result = mysql_query($query);
        $affect += mysql_affected_rows();
        
        // Komunikat o sukcesie lub niepowodzeniu.
        if ($affect > 0) {
            echo '<p><b>Adres URL został usunięty!</b></p>';
        } else { // Żaden wiersz nie został zmodyfikowany.
            echo '<p><font color="red">Na skutek błędu systemowego nie można było przetworzyć przesłanych danych. Przepraszamy za zaistniałą niedogodność.</font></p>';
            // Wyświetlanie zapytań i wywoływanie funkcji mysql_error() (po każdym wywołaniu mysql_query() call) w celach diagnostycznych.
        }
        
        // Zakończenie strony.
        include ('./includes/footer.html');
        exit(); // Zakończenie działania skrypu.
        
    } else { // Edycja adresu URL (operacja domyślna).
    
        // Sprawdzanie poprawności wszystkich pól formularza!
    
        // Sprawdzanie adresu URL.
        if (eregi ('^([[:alnum:]\-\.])+(\.)([[:alnum:]]){2,4}([[:alnum:]/+=%&_\.~?\-]*)$', $_POST['url'])) {
            $u = escape_data($_POST['url']);
        } else {
            $u = FALSE;
            echo '<p><font color="red">Proszę wprowadzić prawidłowy adres URL!</font></p>';
        }
        
        // Sprawdzanie tytułu adresu URL.
        if (!empty($_POST['title'])) {
            $t = escape_data($_POST['title']);
        } else {
            $t = FALSE;
            echo '<p><font color="red">Proszę wprowadzić nazwę (tytuł) adresu URL!</font></p>';
        }
        
        // Sprawdzanie opisu.
        if (!empty($_POST['description'])) {
            $d = escape_data($_POST['description']);
        } else {
            $d = FALSE;
            echo '<p><font color="red">Proszę wprowadzić opis!</font></p>';
        }
        
        // Sprawdzanie kategorii.
        if (isset($_POST['types']) && (is_array($_POST['types']))) {
            $type = TRUE;
        } else {
            $type = FALSE;
            echo '<p><font color="red">Proszę wybrać przynajmniej jedną kategorię!</font></p>';
        }
    
        if ($u && $t && $d && $type) { // Jeśli wszystko jest w porządku...
        
            // Aktualizacja tabeli urls.
            $query1 = "UPDATE urls SET url='$u', title='$t', description='$d' WHERE url_id=$uid";
            $result1 = mysql_query($query1);
            
            // Aktualizacja tabeli url_associations.
            // Pobranie starych kategorii.
            $exist_types = unserialize(urldecode($_POST['exist_types']));
            
            if ($_POST['types'] != $exist_types) { // Dokonano zmiany kategorii.
            
                // Ustalenie nowej i starej kategorii.
                $add = array_diff($_POST['types'], $exist_types);
                $delete = array_diff($exist_types, $_POST['types']);
                
                // Dodawanie nowych typów (w razie potrzeby).
                if (!empty($add)) {
                    $query2 = 'INSERT INTO url_associations (url_id, url_category_id, approved) VALUES ';
                    foreach ($add as $v) {
                        $query2 .= "($uid, $v, 'Y'), ";
                    }
                    $query2 = substr ($query2, 0, -2); // Odcinanie ostatniego przecinka i spacji.
                    $result2 = mysql_query ($query2); // Wykonanie zapytania.
                } else { // Nie ma nowych typów.
                    $result2 = TRUE;
                }
                
                // Usuwanie starych typów (w razie potrzeby).
                if (!empty($delete)) {
                    $query3 = "DELETE FROM url_associations WHERE (url_id=$uid) AND (url_category_id IN (". implode (',', $delete) . "))";
                    $result3 = mysql_query($query3);
                } else { // Nie ma starych typów.
                    $result3 = TRUE;
                }
                
            } else { // Nie dokonano żadnych zmian kategorii.
                $result2 = TRUE;
                $result3 = TRUE;
            }
            
            // Komunikat o sukcesie lub niepowodzeniu.
            if ($result1 && $result2 && $result3) {
                echo '<p><b>Adres URL został zmodyfikowany!</b></p>';
            } else {
                echo '<p><font color="red">Na skutek błędu systemowego nie można było przetworzyć przesłanych danych. Przepraszamy za zaistniałą niedogodność.</font></p>';
                // Wyświetlanie zapytań i wywoływanie funkcji mysql_error() (po każdym wywołaniu mysql_query() call) w celach diagnostycznych.
            }

        } else { // Jeśli nie powiódł się jeden z testów danych.
            echo '<p><font color="red">Proszę spróbować jeszcze raz.</font></p>';        
        }

    } // Koniec instrukcji if-else (edycja-usuwanie)

} // Koniec instrukcji warunkowej sprawdzającej wprowadzone dane.

// --------- WYŚWIETLANIE FORMULARZA ---------

// Pobieranie bieżących informacji o adresie URL.
$query = "SELECT url, title, description, url_category_id FROM urls LEFT JOIN url_associations USING (url_id) WHERE urls.url_id=$uid";        
$result = mysql_query ($query);

// Pobieranie wszystkich informacji z pierwszego rekordu.
$exist_types = array(); // Zerowanie.
list($url, $title, $desc, $exist_types[]) = mysql_fetch_array ($result, MYSQL_NUM);

// Pobieranie pozostałych wartości url_category_id.
while ($row = mysql_fetch_array($result, MYSQL_NUM)) {
    $exist_types[] = $row[3];
}
?>
<form action="edit_url.php" method="post">
    <fieldset><legend>Edycja adresu URL:</legend>
    
    <p><b>Wybierz operację:</b> <input type="radio" name="which" value="edit" checked="checked" /> Edycja <input type="radio" name="which" value="delete" /> Usuwanie</p>
    
    <p><b>Adres URL:</b> <input type="text" name="url" size="60" maxlength="60" value="<?php echo $url; ?>" /><br /><small>Nie dołączaj początkowego identyfikatora <i>http://</i>.</small></p>
    
    <p><b>Nazwa (tytuł) adresu URL:</b> <input type="text" name="title" size="60" maxlength="60" value="<?php echo $title; ?>" /></p>
    
    <p><b>Opis:</b> <textarea name="description" cols="40" rows="5"><?php echo $desc; ?></textarea></p>
    
    <p><b>Kategoria (kategorie):</b> <select name="types[]" multiple="multiple" size="5">
    <?php // Tworzenie menu rozwijanego.
    $query = "SELECT * FROM url_categories ORDER BY category ASC";        
    $result = @mysql_query ($query);
    while ($row = mysql_fetch_array ($result, MYSQL_NUM)) {
        echo "<option value=\"$row[0]\"";
        // Przywołanie poprzednich wartości (w razie potrzeby).
        if (in_array($row[0], $exist_types)) {
            echo ' selected="selected"';
        }
        echo ">$row[1]</option>\n";
    }
     ?>
    </select></p>
    
    </fieldset>
    <input type="hidden" name="submitted" value="TRUE" />
    <?php // Zapisanie wymaganych wartości ukrytych.
        echo '<input type="hidden" name="exist_types" value="' . urlencode(serialize($exist_types)) . '" />
        <input type="hidden" name="uid" value="' . $uid . '" />
        ';
    ?>    
    <div align="center"><input type="submit" name="submit" value="Prześlij" /></div>

</form>
<?php
mysql_close(); // Zamknięcie połączenia z bazą danych.
include ('./includes/footer.html');
?>
