<?php
define('DEV', true);  // Rozwijany projekt czy wersja produkcyjna? Projekt = true | Produkcja = false
define('DOMENA', 'http://localhost:8888');  // Domena (do tworzenia odsyłaczy w e-mailach)
define('ROOT_FOLDER', 'public');           // Nazwa katalogu głównego dokumentów (np. public, content, htdocs)

// Deklaracja DOC_ROOT jest związana z istnieniem kilku wersji przykładowej strony
// Na serwerze produkcyjnym do katalogu dokumentów wystarczy odwołać się ukośnikiem
$ten_katalog   = substr(__DIR__, strlen($_SERVER['DOCUMENT_ROOT']));
$katalog_nadrzedny = dirname($ten_katalog);   
define("DOC_ROOT", $katalog_nadrzedny . DIRECTORY_SEPARATOR . ROOT_FOLDER . DIRECTORY_SEPARATOR);

// Ustawienia bazy danych
$typ        = 'mysql';                    // Typ bazy danych
$serwer     = 'localhost';                // Nazwa hosta
$db         = 'phpmysql-2';               // Nazwa bazy
$port       = '';                         // Typowe numery portu to 8889 w MAMP i 3306 w XAMPP
$kodowanie  = 'utf8mb4';                  // 4-bajtowe kodowanie UTF-8
$uzytkownik = '';                     // Wpisz SWOJĄ nazwę konta
$haslo      = '';                         // Wpisz SWOJE hasło

// NIE ZMIENIAJ PONIŻSZEGO WIERSZA
$dsn = "$typ:host=$serwer;dbname=$db;port=$port;charset=$kodowanie"; // Tworzenie DSN

// Ustawienia serwera SMTP - wpisz dane swojego serwera
$ustaw_email = [
    'serwer'         => '',
    'port'           => '',
    'uzytkownik'     => '',
    'haslo'          => '',
    'bezpieczenstwo' => '',
    'admin_email'    => '',
    'debug'          => (DEV) ? 2 : 0,
];

// Przesyłanie obrazów
define('TYPY_MIME', ['image/jpeg', 'image/png', 'image/gif',]);  // Dozwolone typy plików
define('ROZSZERZENIA', ['jpeg', 'jpg', 'png', 'gif',]);          // Dozwolone rozszerzenia
define('MAX_ROZMIAR', '5242880');                                // Maksymalny rozmiar pliku
// NIE EDYTUJ:
define('WYSLANE', dirname(__DIR__, 1) . DIRECTORY_SEPARATOR . ROOT_FOLDER . DIRECTORY_SEPARATOR . 'wyslane' . DIRECTORY_SEPARATOR); // Katalog wysyłania obrazów
