<?php
declare(strict_types = 1);                                 // Włącz ścisłą kontrolę typów
include '../../src/bootstrap.php';                         // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);  // Pobierz i sprawdź id
$kategoria = [];                                           // Zainicjalizuj tablicę kategorii
$usunieto   = null;                                        // Czy kategoria została usunięta?

if (!$id) {                                                // Jeśli nie ma prawidłowego id
    przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

$kategoria = $cms->pobierzKategorie()->pobierz($id);       // Pobierz kategorię
if (!$kategoria) {                                         // Jeśli nie ma prawidłowej kategorii
    przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {               // Jeśli formularz został przesłany
    if ($id) {                                            // Jeśli id jest prawidłowy
        $usunieto  = $cms->pobierzKategorie()->usun($id); // Usuń kategorię
        if ($usunieto  === true) {                        // Jeśli zadziałało
            przekieruj('admin/kategorie.php', ['sukces' => 'Kategoria została usunięta']); // Przekieruj
        }
        if ($usunieto  === false) {                        // Jeśli kateegoria zawiera publikacje
            przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Kategoria zawiera publikacje, które 
			powinny zostać przeniesione lub skasowane przed jej usunięciem']); // Przekieruj z błędem
        }
    }
}

$dane['kategoria'] = $kategoria;                           // Kategoria

echo $twig->render('admin/usun-kategorie.html', $dane);    // Wyrenderuj szablon