<?php
declare(strict_types = 1);                                  // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                       // Zaimportuj przestrzeń nazw Weryfikacja

$blad = false;                                                  // Komunikat błędu
$wyslano  = false;                                              // Czy e-mail został wysłany?

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                     // Jeśli formularz został przesłany
    $email = $_POST['email'];                                   // Pobierz e-mail
    $blad = Weryfikacja::czyEmail($email) ? '' : 'Podaj swój adres e-mail'; // Sprawdź
    if ($blad === '') {                                                     // Jeśli poprawny
        $id = $cms->pobierzUczestnika()->pobierzIdPrzezEmail($email);       // Pobierz id użytkownika
        if ($id) {                                                          // Jeśli id odnaleziono
            $token = $cms->pobierzToken()->utworz($id, 'reset_hasla');      // Token
            $link  = DOMENA . DOC_ROOT . 'resetowanie-hasla/?token=' . $token; // Link
            $temat = 'Resetowanie hasła';                                   // Temat i treść
            $tresc  = 'Aby zresetować hasło, kliknij: <a href="' . $link . '">' . $link . '</a>';
            $mail  = new \PhpMysql\Email\Email($ustaw_email);               // Obiekt Email
            $wyslano  = $mail->wyslijEmail($ustaw_email['admin_email'], $email, 
               $temat, $tresc);                                             // Wyślij e-mail
        }
    }
}

$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();           // Kategorie do nawigacji
$dane['blad']      = $blad;                                                 // Błędy weryfikacji
$dane['wyslano']   = $wyslano;                                              // Czy e-mail został wysłany?

echo $twig->render('odzyskiwanie-hasla.html', $dane);                       // Wyrenderuj szablon