<?php
declare(strict_types = 1);                                  // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                       // Zaimportuj klasę Weryfikacja

$od    = '';                                                // Zainicjalizuj nadawcę
$wiadomosc = '';                                            // Wiadomość
$bledy  = [];                                               // Tablica na błędy
$sukces = '';                                               // Komunikat o powodzeniu

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                 // Jeśli formularz został przesłany
    $od              = $_POST['email'];                     // Adres e-mail
    $wiadomosc           = $_POST['wiadomosc'];             // Wiadomość
    $bledy['email']   = Weryfikacja::czyEmail($od)            ? '' : 'Nieprawidłowy e-mail';
    $bledy['wiadomosc'] = Weryfikacja::czyTekst($wiadomosc, 1, 1000) ? '' : 'Prosze wpisać wiadomość do 1000 znaków';
    $nieprawidlowe = implode($bledy);                       // Połącz komunikaty błędów
    if ($nieprawidlowe) {                                   // Jeśli były błędy
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';    // Utwóz ostrzeżenie
    } else {                                                // W przeciwnym razie spróbuj wysłać e-mail
        $temat = "Zgłoszenie od " . $od;        // Utwórz temat wiadomości
        $email   = new \PhpMysql\Email\Email($ustaw_email); // Create email object
        $email->wyslijEmail($ustaw_email['admin_email'],  $ustaw_email['admin_email'],
          $temat, $wiadomosc);                              // Wyślij
        $sukces = 'Wiadomość została wysłana';              // Wiadomość o powodzeniu
    }
}
$dane['nawigacja'] = $cms->pobierzKategorie()->pobierzWszystko();        // Wszystkie kategorie do nawigacji

// Poniższe wartości są tworzone tylko jeśli użytkownik wysłał formularz
$dane['od']      = $od;                                     // Nadawca
$dane['wiadomosc'] = $wiadomosc;                            // Wiadomość
$dane['bledy']     = $bledy;                                // Błędy
$dane['sukces']    = $sukces;                               // Komunikat o powodzeniu

echo $twig->render('kontakt.html', $dane);                  // Wyrenderuj szablon Twiga