<?php
// CZĘŚĆ A: Konfiguracja
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
use PhpMysql\Weryfikacja\Weryfikacja;                    // Zaimportuj przestrzeń Weryfikacja

include '../../src/bootstrap.php';                       // Dołącz plik konfiguracyjny
czyAdmin($sesja->rola);                                  // Sprawdź status administratora

// Inicjalizacja zmiennej potrzebnej w kodzie PHP
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Pobierz i sprawdź id
$zapisano = null;                                        // Czy kategoria została zapisana

// Inicjalizacja zmiennych potrzebnych w kodzie HTML
$kategoria = [
    'id'          => $id,
    'nazwa'        => '',
    'opis' => '',
    'nawigacja'  => false,
];                                                       // Inicjalizacja tablicy kategorii
$bledy = [
    'ostrzezenie'     => '',
    'nazwa'        => '',
    'opis' => '',
];                                                       // Inicjalizacja tablicy błędów

if ($id) {                                               // Jeśli jest id i formularz nie był przesłany
    $kategoria = $cms->pobierzKategorie()->pobierz($id); // Pobierz dane kategorii
    if (!$kategoria) {                                   // Jeśli nie ma danych kategorii
        przekieruj('admin/kategorie.php', ['niepowodzenie' => 'Nie odnaleziono kategorii']); // Przekieruj z błędem
    }
}

// CZĘŚĆ B: Pobierz i zweryfikuj dane z formularza
if ($_SERVER['REQUEST_METHOD'] == 'POST') {               // Jeśli formularz został przesłany
    $kategoria['nazwa']        = $_POST['nazwa'];         // Pobierz nazwę
    $kategoria['opis'] = $_POST['opis'];                  // Pobierz opis
    $kategoria['nawigacja']  = isset($_POST['nawigacja']) ? 1 : 0; // Pobierz nawigację
    $kategoria['seo_nazwa']    = utworz_nazwe_seo($kategoria['nazwa']);  // Nazwa przyjazna SEO

    $bledy['nazwa']          = (Weryfikacja::czyTekst($kategoria['nazwa'], 1, 24))
        ? '' : 'Nazwa powinna się składać z 1-24 znaków.';   // Sprawdź nazwę
    $bledy['opis']   = (Weryfikacja::czyTekst($kategoria['opis'], 1, 254))
        ? '' : 'Opis powinien się składać z 1-254 znaków.';  // Sprawdź opis
    $nieprawidlowe                 = implode($bledy);        // Połącz komunikaty błędów

    // CZĘŚĆ C: Sprawdź prawidłowość danych i zaktualizuj bazę
    if ($nieprawidlowe) {                                    // Jeśli dane są niepoprawne
        $bledy['ostrzezenie'] = 'Proszę poprawić błędy';     // Komunikat błędu
    } else {                                                 // W przeciwnym razie utwórz / zaktualizuj
        $argumenty = $kategoria;                             // Ustaw parametry dla SQL
        if ($id) {                                           // Jeśli jest id
            $zapisano = $cms->pobierzKategorie()->aktualizuj($argumenty); // Spróbuj zaktualizować kategorię
        } else {                                             // Jeśli nie ma id
            unset($argumenty['id']);                         // Usuń id z tablicy
            $zapisano = $cms->pobierzKategorie()->utworz($argumenty);     // Spróbuj utworzyć kategorię
        }
        if ($zapisano === true) {                            // W razie powodzenia
            przekieruj('admin/kategorie.php', ['sukces' => 'Kategoria została zapisana']); // Przekieruj
        }
        if ($zapisano === false) {                           // Jeśli kategoria się powtarza
            $bledy['ostrzezenie'] = 'Nazwa kategorii jest już używana'; // Zapisz komunikat błędu
        }
    }
}

$dane['kategoria'] = $kategoria;                             // Dodaj kategorie do szablonu
$dane['bledy']   = $bledy;                                   // Dodaj błędy do szablonu

echo $twig->render('admin/kategoria.html', $dane);           // Wyrenderuj szablon Twiga