--
-- Baza danych: `phpmysql-2`
-- Druga baza danych
-- --------------------------------------------------------

--
-- Struktura tabeli `publikacje`
--

CREATE TABLE `publikacje` (
  `id` int(11) NOT NULL,
  `tytul` varchar(80) COLLATE utf8mb4_unicode_ci NOT NULL,
  `podsumowanie` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tresc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `utworzono` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_kategorii` int(11) NOT NULL,
  `id_uczestnika` int(11) NOT NULL,
  `id_obrazu` int(11) DEFAULT NULL,
  `opublikowano` tinyint(4) NOT NULL DEFAULT '0',
  `seo_tytul` varchar(244) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `publikacje`
--

INSERT INTO `publikacje` (`id`, `tytul`, `podsumowanie`, `tresc`, `utworzono`, `id_kategorii`, `id_uczestnika`, `id_obrazu`, `opublikowano`, `seo_tytul`) VALUES
(1, 'Broszura Systemic', 'Projekt broszury na festiwal naukowy', '<p>Ten projekt broszury jest częścią zestawu materiałów reklamowych promujących festiwal nauki Systemic. Materiały te charakteryzują się złożoną szatą graficzną, będącą abstrakcyjną siatką ścieżek reprezentujących wybór i podejmowanie decyzji w projektowaniu złożonych systemów.</p>', '2021-01-26 12:21:03', 1, 2, 1, 1, 'broszura-systemic'),
(2, 'Prognoza', 'Ilustracja dla magazynu o modzie', '<p>Ilustracja została zamówiona przez magazyn o modzie na potrzeby artykułu o przyszłych trendach. W projekcie wykorzystano luksusowe torebki, które naśladują chmury przypominające symbolikę stosowaną w prognozach pogody. Zastosowane powtórzenia i schematy podkreślają moc prognoz.</p>', '2021-01-28 19:44:03', 3, 2, 19, 1, 'prognoza'),
(3, 'Basen', 'Zdjęcie do magazynu architektonicznego', '<p>To zdjęcie jest jednym z serii zamówionych do artykułu w czasopiśmie architektonicznym, w którym zaprezentowano baseny w prywatnych rezydencjach. Estetyka różnorodnych lokalizacji nawiązywała do połowy ubiegłego wieku. Zdjęcia zostały zrobione na ziarnistym, czarno-białym filmie fotograficznym.</p>', '2021-02-02 09:45:52', 4, 1, 3, 1, 'basen'),
(4, 'Chodzące ptaki', 'Projekt do teledysku', '<p>Założeniem tego teledysku było połączenie psychodelicznego klimatu lat sześćdziesiątych z chropawą estetyką z lat siedemdziesiątych i ukazanie tego przez pryzmat animacji w stylu Ulicy Sezamkowej. Dzięki ponad dwóm milionom wyświetleń online grafika z powodzeniem promowała piosenkę w wielu kanałach mediów społecznościowych.</p>', '2021-02-12 11:05:35', 3, 3, 4, 1, 'chodzace-ptaki'),
(5, 'Siostry', 'Ilustracja do artykułu o psychologii', '<p>Artykuł, któremu towarzyszą te ilustracje, zwraca uwagę na zmieniający się krajobraz powiązań rodzinnych w dzisiejszych czasach w porównaniu do obrazu sytuacji sprzed półwiecza. Celem było zobrazowanie rozpadających się więzi międzyludzkich wskutek rosnącego rozproszenia społeczności na całym globie.</p>', '2021-02-26 15:31:16', 3, 3, 5, 1, 'siostry'),
(6, 'Mikrowydmy', 'Fotografia do czasopisma naukowego', '<p>Fotografia ta została zamówiona jako ilustracja do artykułu naukowego o małych ekosystemach w środowisku przybrzeżnym. Ze względu na miniaturową skalę tematu, do uchwycenia drobnych szczegółów użyto obiektywu makro. Zdjęcia powstały na północnym wybrzeżu Australii.</p>', '2021-03-02 21:02:47', 4, 1, 6, 1, 'mikrowydmy'),
(7, 'Strona Milk Beach', 'Strona albumu muzycznego', '<p>Ta oparta na zdjęciach wykorzystanych do zaprojektowania okładki albumu strona udostępnia użytkownikom wygodne narzędzia do odsłuchiwania muzyki cyfrowej. Zadbano o to, by fani mogli bliżej poznać swój ulubiony zespół i byli informowani o premierach nowych płyt i utworów.</p>', '2021-03-06 10:16:22', 2, 1, 7, 1, 'strona-milk-beach'),
(8, 'Aplikacja Wellness', 'Aplikacja dla placówki zdrowia', '<p>Sieć placówek służby zdrowia Wellness wymagała aplikacji, która umożliwiałaby członkom przeglądanie i rezerwowanie zajęć. Na podstawie księgi marki opracowano wygląd witryny z zachowaniem sugerowanego, minimalistycznego stylu.</p>', '2021-03-12 14:45:49', 2, 2, 8, 1, 'aplikacja-wellness'),
(9, 'Milk Beach Music', 'Zdjęcia do serii albumów muzycznych', '<p>Wytwórnia muzyczna, która wydała tę serię, chciała uchwycić plażę, która zainspirowała jej stworzenie. Wiele zdjęć (w tym widoki panoramiczne i zbliżenia) wykonano na miejscu w Milk Beach w Sydney w Australii. W postprodukcji nadano im wygląd bichromii.</p>', '2021-03-12 17:09:40', 4, 1, 9, 1, 'milk-beach-music'),
(10, 'Mural Polite Society', 'Wielkoformatowe ilustracje dla producenta odzieży', '<p>To jedna z kilku ilustracji zamówionych przez firmę Polite Society do dekoracji ich nowej kolekcji jesienno-zimowej. Odzwierciedlają one nowoczesną estetykę najnowszej kolekcji i są przystosowane do wykorzystania w różnych formach (takich jak murale, wizualizacje cyfrowe i poligrafia).</p>', '2021-03-16 14:14:40', 3, 1, 10, 1, 'mural-polite-society'),
(11, 'Strona i aplikacja Stargazer', 'Projekt strony internetowej i aplikacji dla festiwalu muzycznego', '<p>Witryna festiwalu muzycznego Stargazer opiera się przede wszystkim na estetycznej typografii i zawiera informacje o występach znanych wykonawców. Umożliwia użytkownikom przeglądanie harmonogramu festiwalu i zakup biletów, a także planować przyjazd i rezerwować posiłki.</p>', '2021-03-17 18:01:19', 2, 3, 11, 1, 'strona-aplikacja-stargazer'),
(12, 'The Ice Palace', 'Projekt okładki', '<p>Projekt okładki reedycji klasycznej norweskiej powieści „The Ice Palace” wydanej nakładem Chimney Press. Projekt odzwierciedla zwięzły styl i poczucie niepokoju, którym nasycona jest powieść i sam zdaje się uwięziony w okowach lodu. Książkę wydano w płóciennej oprawie, a gruba okładka skrywa jej mroźne tajemnice.</p>', '2021-03-20 11:24:52', 1, 2, 12, 1, 'the-ice-palace'),
(13, 'Strona Chimney Press', 'Strona internetowa wydawcy książek', '<p>Projekt powstał na podstawie szeroko zakrojonych badań nad postrzeganiem wizerunku marki Chimney Press w wielu kanałach. Zebrane informacje pokazały, że klienci chcą być na bieżąco informowani o premierach i zapowiedziach, a także udostępniać te informacje w swoich sieciach społecznościowych.</p>', '2021-03-21 08:44:01', 2, 2, 13, 1, 'strona-chimney-press'),
(14, 'Okładka albumu Milk Beach', 'Okładka albumu muzycznego', '<p>Okładka, zaprojektowana na podstawie formacji skalnych zdobiący tytułowy rejon Milk Beach, tworzy piękny i pogodny kontekst dla niezwykle udanej serii nagrań. W tym projekcie wykorzystano karton pochodzący z recyklingu i nadano mu subtelną kolorystykę.</p>', '2021-03-27 13:15:20', 1, 1, 14, 1, 'okladka-albumu-milk-beach'),
(15, 'Morski pejzaż', 'Zdjęcie na wystawę sztuki', '<p>To ujęcie morza w Margate było częścią wystawy zbiorowej w galerii sztuki Turner Contemporary Art w hrabstwie Kent w Anglii. Wydrukowany w dużej skali, wyciszający pejzaż odsłania ponadczasowe piękno słonych wód, które od wieków przyciągają londyńczyków.</p>', '2021-04-03 19:36:08', 4, 2, 15, 1, 'morski-pejzaz'),
(16, 'Strona Polite Society', 'Strona producenta odzieży', '<p>Witryna Polite Society została przebudowana od podstaw na podstawie spostrzeżeń zaczerpniętych z jej starej wersji i dostosowana do wymogów dzisiejszego użytkownika. Zadbano o możliwość dostosowania strony do wielu urządzeń i stworzono nowy back-end, uwzględniający wymogi związane z przyszłym rozwojem firmy.</p>', '2021-04-06 10:21:44', 2, 1, 16, 1, 'strona-polite-society'),
(17, 'Snow Search', 'Grafika do gry mobilnej', '<p>Te ilustracje przedstawiające młodego chłopca i jego psa stały się kanwą dla bardzo udanej gry animowanej o nazwie Snow Search. Gra, która została zaprojektowana na urządzenia mobilne, otrzymała kilka nagród za projekt i mechanikę. Obecnie trwają prace nad ilustracjami do kontynuacji.</p>', '2021-04-08 08:46:31', 3, 3, 17, 1, 'snow-search'),
(18, 'Strona kwiaciarni', 'Strona internetowa dla kwiaciarni', '<p>Kwiaciarnia z Brooklynu potrzebowała nowoczesnej witryny internetowej, wspierającej rosnący zakres usług. Współpracując ze stylistą i fotografem, stworzyliśmy przyjemną i prostą w obsłudze witrynę. Od czasu ponownego uruchomienia strony liczba zapytań online znacznie wzrosła.</p>', '2021-04-08 17:05:19', 2, 1, 18, 1, 'strona-kwiaciarni'),
(19, 'Upadek przemysłu', 'Fotografia do magazynu', '<p>To zdjęcie starego sprzętu przemysłowego w nieużywanym doku stanowiło ilustrację do eseju w czasopiśmie o urbanistyce i rewitalizacji. Istotą projektu było dostrzeżenie wizualnego piękna tkwiącego w rozpadzie i zainspirowanie czytelników do postępowania zgodnie z zasadami zrównoażonego rozwoju.</p>', '2021-04-11 10:52:02', 4, 2, 21, 1, 'upadek-przemyslu'),
(20, 'Wizytówki Chimney Press', 'Projekt wizytówek dla wydawnictwa', '<p>Oprócz kilku innych elementów identyfikacji wizualnej, firma Chimney Press potrzebowała nowych wizytówek dla powiększającego się personelu biurowego. Zgodnie z misją firmy opierającej się na reedycjach starszych tytułów, podstawą nowoczesnego projektu była czysta i inspirowana stylem vintage estetyka.</p>', '2021-04-15 09:04:39', 1, 2, 20, 1, 'wizytowki-chimney-preess'),
(21, 'Stargazer', 'Ilustracje na festiwal muzyczny', '<p>Seria ilustracji zamówiona na potrzeby materiałów promocyjnych festiwali muzycznych Stargazer. W odróżnieniu od lat poprzednich, w tym roku postanowiono nie eksponować nocnego nieba, lecz skupić się na pięknie i zadziwieniu patrzących w gwiazdy.</p>', '2021-04-19 18:08:11', 3, 3, 23, 1, 'stargazer'),
(22, 'Plakaty Polite Society', 'Projekty plakatów dla firmy odzieżowej', '<p>Plakaty te powstały z myślą o zwiększeniu świadomości marki w świecie mody w ramach międzynarodowej kampanii przed nadchodzącym sezonem jesienno-zimowym. Klient wymagał czegoś estetycznie nowoczesnego, odzwierciedlającego żywą paletę barw nowej kolekcji.</p>', '2021-04-22 07:49:27', 1, 1, 2, 1, 'plakaty-polite-society'),
(23, 'Golden Brown', 'Fotografia do książki wnętrzarskiej', '<p>To zdjęcie jest jednym z kilku zamieszczonych w książce Golden Brown, poświęconej projektowaniu wnętrz. Zaprezentowane w niej wnętrza pokazują aktualny trend powrotu do lat 70., a kolorystyka fotografii odzwierciedla ich ciepłą paletę barw w odcieniach ziemi.</p>', '2021-04-25 13:51:19', 4, 3, 22, 1, 'golden-brown'),
(24, 'Przewodnik turystyczny', 'Projekt graficzny serii przewodników turystycznych', '<p>Bestsellerowa seria przewodników turystycznych Featherview wymagała odświeżenia wyglądu i stylu ich najnowszej serii książek dotyczących Azji. Wydawca szukał czystego i prostego rozwiązania - uniwersalnego projektu, w którym odnajdzie się bywalec kawiarni i backpacker.</p>', '2021-04-25 19:11:42', 1, 1, 24, 1, 'przewodnik-turystyczny'),
(25, 'Budda', 'Zdjęcie do magazynu', '<p>Artykuł, któremu towarzyszy to zdjęcie, dotyczy rosnącej popularności medytacji uważności w branży zdrowia psychicznego. W tekście prześledzono historię tego rodzaju medytacji aż do jej buddyjskich korzeni.</p>', '2021-08-03 09:30:19', 4, 12, 25, 1, 'budda'),
(26, 'Faces in the Water', 'Projekt okładki książki', '<p>Firma Chimney Press poprosiła o projekt okładki książki do tego przejmującego portretu przeżyć kobiety w zakładzie psychiatrycznym. Typografia naśladuje drobne fale na powierzchni wody i w moim odczuciu wpisuje się w poetycki i subtelny motyw książki..</p>', '2021-08-03 12:11:24', 1, 8, 26, 1, 'faces-in-the-water'),
(27, 'Łosoś', 'Zdjęcie do recenzji restauracji', '<p>To zdjęcie jest częścią serii fotografii dla nowej restauracji serwującej owoce morza. Ukazało się wraz z recenzją lokalu w The New York Timesie. Zdjęcia pokazują świeże, organiczne menu i zostały zrobione w duchu minimalistycznej estetyki \„czystego jedzenia\”.</p>', '2021-08-03 09:23:07', 4, 10, 27, 1, 'losos'),
(28, 'Quiet', 'Projekt okładki książki', '<p>Projekt okładki książki o filmach niemych, wykorzystujący charakterystyczną stylistykę plansz dialogowych z dawnej kinematografii. Okładka została celowo postarzona, a dzięki chropawości materiałów pochodzących z recyklingu, druk ma estetyczny, zmatowiony wygląd.</p>', '2021-08-03 11:21:04', 1, 7, 28, 1, 'quiet'),
(29, 'Zaproszenie Quiet', 'Zaproszenie na premierę dokumentu', '<p>To zaproszenie zostało zaprojektowane na światową premierę i przyjęcie z okazji premiery nowej książki Claude\'a Duponta zatytułowanego \"Quiet: A Silent Film History\". Priorytetowo potraktowana została wizualna spójność zaproszenia z okładką do wspomnianej książki.</p>', '2021-08-03 11:26:29', 1, 7, 29, 1, 'quiet-zaproszenie'),
(30, 'Muzeum', 'Fotografia dla muzeum', '<p>Muzeum MAXII (Narodowe Muzeum Sztuki XXI wieku) w Rzymie zostało zaprojektowane przez Zahę Hadid i jest poświęcone sztuce współczesnej i architekturze. Zadanie polegało na uwiecznieniu neonowej instalacji na zewnątrz, wykonanej przez włoskiego artystę Maurizio Nannucciego.</p>', '2021-08-03 09:06:12', 4, 5, 30, 1, 'muzeum'),
(31, 'New Forest', 'Projekt strony dla oazy artystycznej', '<p>Projekt strony internetowej oazy artystycznej w New Forest ma inspirować artystów i pisarzy do uznania tego miejsca za idealne miejsce do tworzenia. Czysty i klasyczny układ strony pozwala wybrzmieć zdjęciom, ukazującym piękno otoczenia.</p>', '2021-08-04 10:04:37', 2, 7, 31, 1, 'new-forest');

-- --------------------------------------------------------

--
-- Struktura tabeli `kategorie`
--

CREATE TABLE `kategorie` (
  `id` int(11) NOT NULL,
  `nazwa` varchar(24) COLLATE utf8mb4_unicode_ci NOT NULL,
  `opis` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nawigacja` tinyint(1) NOT NULL,
  `seo_nazwa` varchar(244) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `kategorie`
--

INSERT INTO `kategorie` (`id`, `nazwa`, `opis`, `nawigacja`, `seo_nazwa`) VALUES
(1, 'Druk', 'Inspirujące projekty graficzne i komunikacja wizualna w dziedzinie opakowań i szeroko pojętej poligrafii', 1, 'druk'),
(2, 'Digital', 'Strony internetowe i aplikacje wyznaczające nowe standardy cyfrowego projektowania na wszystkich urządzeniach', 1, 'digital'),
(3, 'Ilustracja', 'Prace artystów specjalizujących się w ilustracjach odręcznych i wektorowych', 1, 'ilustracja'),
(4, 'Fotografia', 'Zdjęcia, dzięki którym widz przenosi się do innego świata', 1, 'fotografia');

-- --------------------------------------------------------

--
-- Struktura tabeli `komentarze`
--

CREATE TABLE `komentarze` (
  `id` int(12) NOT NULL,
  `komentarz` varchar(4000) COLLATE utf8mb4_unicode_ci NOT NULL,
  `zamieszczono` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `id_publikacji` int(12) NOT NULL,
  `id_uczestnika` int(12) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `komentarze`
--

INSERT INTO `komentarze` (`id`, `komentarz`, `zamieszczono`, `id_publikacji`, `id_uczestnika`) VALUES
(1, 'Cudo, od razu mam ochotę znów polecieć do Japonii! Czysty projekt, przejrzysty układ informacji i dobre strony ze zdjęciami.', '2021-03-14 17:45:13', 24, 3),
(2, 'Mam przewodnik z tej serii o Nowym Jorku i projekt naprawdę wywarł na mnie wrażenie. To piękny produkt i piękny design. Dobra robota!', '2021-03-14 17:45:15', 24, 6),
(3, 'Kolejna świetna praca Saro, dzięki za podzielenie się nią z nami.', '2021-03-14 17:53:52', 24, 7),
(4, 'Ooo! Boskie! Dodaję ją do mojej listy książek.', '2021-03-14 17:53:54', 24, 9),
(5, 'Wow! Bardzo podoba mi się oświetlenie do tego ujęcia.', '2021-04-03 21:22:53', 23, 4),
(6, 'Następny świetny projekt, Saro!', '2021-04-04 20:15:12', 24, 4),
(7, 'Piękne są te zielone krzesła.', '2021-06-30 17:45:43', 23, 1),
(8, 'Piękne pudełko ', '2021-07-03 11:21:13', 20, 1),
(9, 'Fantastyczna praca!', '2021-08-03 23:14:49', 28, 6),
(10, 'Bardzo inspirujące! Szczególnie podoba mi się typografia na stronie głównej.', '2021-08-09 21:35:16', 31, 1),
(11, 'Jaki font został użyty w tytule?', '2021-08-09 21:36:31', 28, 12),
(12, 'Bardzo wszystkim dziękuję!', '2021-08-10 11:08:37', 24, 1),
(13, 'Genialna ilustracja na okładce. Przypomina mi książki dla dzieci, na których się wychowałem. A typografia pasuje jak ulał.', '2021-08-15 13:40:59', 26, 1),
(14, 'Uroczy kolaż.', '2021-08-18 08:14:08', 17, 7),
(15, 'To taki niesamowity budynek - naprawdę podoba mi się sposób, w jaki go uchwyciłeś.', '2021-08-21 15:34:37', 30, 7),
(16, 'Założę się, że to wielka rzecz. I dobrze widać ręcznie rysowane elementy.', '2021-08-22 11:17:50', 10, 5),
(17, 'Kocham zdjęcia bez ramek i tę subtelną kolorystykę.', '2021-08-27 21:49:29', 31, 6),
(18, 'Cudne zdjęcie, Emiko! Rewelacja.', '2021-09-03 01:15:30', 23, 6),
(19, 'Dokładnie tak. Całkiem nie jak w Rzymie, a światło na tym ujęciu jest po prostu genialne.', '2021-09-05 17:22:35', 30, 11),
(20, 'Doskonały dobór barw, a prosta czcionka jest idealna.', '2021-09-07 08:53:11', 22, 11),
(21, 'Efekt bichromii! Mega!', '2021-09-07 09:01:32', 9, 11),
(22, 'Założę się, że wyglądałoby to genialnie na wydruku z risografu.', '2021-09-11 22:21:54', 9, 9),
(23, 'Tak! I drugi plan jest jeszcze bardziej realistyczny.', '2021-09-13 14:00:42', 17, 12),
(24, 'Niezłe, naprawdę niezłe. Dobra robota.', '2021-09-13 16:56:36', 17, 10),
(25, 'Okładka albumu w dziale druku też jest świetna.', '2021-09-15 12:42:07', 9, 3),
(26, 'Świetna praca, Luke!', '2021-09-18 20:18:10', 13, 3),
(27, 'Wszystkie są naprawdę fajne. Zdjęcie i okładka albumu współgrają idealnie.', '2021-09-21 11:16:28', 7, 3);

-- --------------------------------------------------------

--
-- Struktura tabeli `obrazy`
--

CREATE TABLE `obrazy` (
  `id` int(11) NOT NULL,
  `plik` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(1000) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `obrazy`
--

INSERT INTO `obrazy` (`id`, `plik`, `alt`) VALUES
(1, 'systemic-brochure.jpg', 'Broszura dla festiwalu naukowego Systemic'),
(2, 'forecast.jpg', 'Ilustracja torebki'),
(3, 'swimming-pool.jpg', 'Zdjęcie basenu'),
(4, 'birds.jpg', 'Kolaż z dwoma ptakami'),
(5, 'sisters.jpg', 'Dwie siostry'),
(6, 'micro-dunes.jpg', 'Zdjęcie malutkich wydm'),
(7, 'milk-beach.jpg', 'Serwis Milk Beach'),
(8, 'wellness.jpg', 'Harmonogram jogi dla sieci Wellness'),
(9, 'milk-beach-skyline.jpg', 'Zdjęcie portu w Sydney zrobione z Milk Beach'),
(10, 'polite-society-mural.jpg', 'Mural dla Polite Society'),
(11, 'stargazer.jpg', 'Projekt dla strony Stargazer'),
(12, 'the-ice-palace.jpg', 'Okładka książki The Ice Palace'),
(13, 'chimney.jpg', 'Strona Chimney Press'),
(14, 'milk-beach-album.jpg', 'Okładka płyty winylowej dla Milk Beach'),
(15, 'seascape.jpg', 'Zdjęcie morza z Margate Beach'),
(16, 'polite-society.jpg', 'Strona Polite Society'),
(17, 'snow-search.jpg', 'Ilustracja chłopca w śniegu'),
(18, 'floral.jpg', 'Strona dla kwiaciarni'),
(19, 'abandoned.jpg', 'Zdjęcie wycofanych z eksploatacji żurawi dokowych'),
(20, 'chimney-cards.jpg', 'Wizytówki dla Chimney Press'),
(21, 'stargazer-mascot.jpg', 'Ilustracja dziewczynki patrzącej w niebo'),
(22, 'polite-society-posters.jpg', 'Zdjęcie trzech plakatów dla Polite Society'),
(23, 'golden-brown.jpg', 'Zdjęcie wnętrza kawiarni'),
(24, 'featherview.jpg', 'Dwie strony z przewodnika pokazujące zamek Nijo'),
(25, 'buddha.jpg', 'Posąg Buddy w oczku wodnym'),
(26, 'faces.jpg', 'Okładka książki Faces in the Water autorstwa Janet Frame'),
(27, 'salmon.jpg', 'Łosoś z cukinią'),
(28, 'quiet.jpg', 'Okładka książki Quiet - A Silent Film History'),
(29, 'quiet-invite.jpg', 'Zaproszenie na premierę'),
(30, 'museum.jpg', 'Fasada muzeum MAXII w Rzymie'),
(31, 'new-forest.jpg', 'Oaza artystyczna New Forest na iPadzie Pro');

-- --------------------------------------------------------

--
-- Struktura tabeli `polubienia`
--

CREATE TABLE `polubienia` (
  `id_publikacji` int(8) NOT NULL,
  `id_uczestnika` int(8) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `polubienia`
--

INSERT INTO `polubienia` (`id_publikacji`, `id_uczestnika`) VALUES
(2, 1),
(4, 1),
(13, 1),
(15, 1),
(16, 1),
(18, 1),
(20, 1),
(21, 1),
(23, 1),
(24, 1),
(26, 1),
(28, 1),
(29, 1),
(30, 1),
(31, 1),
(1, 3),
(7, 3),
(9, 3),
(10, 3),
(13, 3),
(14, 3),
(19, 3),
(22, 3),
(24, 3),
(27, 3),
(30, 3),
(31, 3),
(19, 4),
(23, 4),
(13, 5),
(16, 5),
(19, 5),
(22, 5),
(24, 5),
(1, 6),
(12, 6),
(15, 6),
(21, 6),
(23, 6),
(31, 6),
(10, 7),
(11, 7),
(19, 7),
(23, 7),
(30, 7),
(2, 8),
(4, 8),
(5, 8),
(6, 8),
(9, 8),
(17, 8),
(18, 8),
(23, 8),
(25, 8),
(28, 8),
(29, 8),
(9, 9),
(10, 9),
(11, 9),
(19, 9),
(20, 9),
(21, 9),
(23, 9),
(24, 9),
(26, 9),
(9, 10),
(18, 10),
(20, 10),
(23, 10),
(25, 10),
(9, 11),
(17, 11),
(21, 11),
(22, 11),
(31, 11),
(9, 12),
(10, 12),
(11, 12),
(17, 12),
(19, 12),
(21, 12),
(23, 12),
(26, 12),
(30, 12),
(31, 12);

-- --------------------------------------------------------

--
-- Struktura tabeli `uczestnicy`
--

CREATE TABLE `uczestnicy` (
  `id` int(11) NOT NULL,
  `imie` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nazwisko` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `haslo` varchar(254) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dolaczyl` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `zdjecie` varchar(254) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rola` varchar(12) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'admin'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `uczestnicy`
--

INSERT INTO `uczestnicy` (`id`, `imie`, `nazwisko`, `email`, `haslo`, `dolaczyl`, `zdjecie`, `rola`) VALUES
(1, 'Sara', 'Miła', 'sara@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-01-26 12:04:23', 'ivy.jpg', 'admin'),
(2, 'Luke', 'Wood', 'luke@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2018-02-01 21:48:25', NULL, 'uczestnik'),
(3, 'Emiko', 'Ito', 'emi@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-02-12 10:53:47', 'emi.jpg', 'uczestnik'),
(4, 'Dot', 'Clarke', 'dot@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-04 08:21:28', 'dot.jpg', 'admin'),
(5, 'Henry', 'Bell', 'henry@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-06 23:47:56', 'henry.jpg', 'uczestnik'),
(6, 'Samira', 'Mirza', 'samira@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-08 12:12:53', 'samira.jpg', 'admin'),
(7, 'Eve', 'Howard', 'eve@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-13 23:49:40', 'eve.jpg', 'uczestnik'),
(8, 'Lily', 'Morgan', 'lily@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-14 11:04:30', 'lily.jpg', 'uczestnik'),
(9, 'Aiden', 'Peterson', 'aiden@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-16 17:51:17', 'aiden.jpg', 'uczestnik'),
(10, 'Hyun-tae', 'Lee', 'hyun@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-16 21:32:27', 'hyun.jpg', 'uczestnik'),
(11, 'Piper', 'Gray', 'piper@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-18 08:18:23', 'piper.jpg', 'uczestnik'),
(12, 'Grace', 'Jackson', 'grace@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-18 12:55:09', 'grace.jpg', 'uczestnik'),
(13, 'Noriko', 'Saito', 'noriko@eg.link', '$2y$10$MAdTTCA0Mi0whewgCcBv4uv0HUgdcAkW1pnqslSi/P2Ca9u5rpZl.', '2021-03-21 15:28:11', 'noriko.jpg', 'uczestnik');

-- --------------------------------------------------------

--
-- Struktura tabeli `tokeny`
--

CREATE TABLE `tokeny` (
  `id` int(11) NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `id_uczestnika` int(255) NOT NULL,
  `wygasa` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cel` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Zrzut danych tabeli `tokeny`
--

INSERT INTO `tokeny` (`id`, `token`, `id_uczestnika`, `wygasa`, `cel`) VALUES
(1, '0d9781153ed42ea7d72b4a4963dbd4f7fbc1d09bca10a8faae55d5dd66441521881a4e51eb17cd62596b156f11218d31436e5ae3381bcb50acbf31dd2c5cd197', 50, '2021-09-09 15:47:04', 'reset_hasla');

--
-- Indeksy dla zrzuconych tabel
--

--
-- Indeksy dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `tytul` (`tytul`),
  ADD KEY `id_kategorii` (`id_kategorii`),
  ADD KEY `id_autora` (`id_uczestnika`),
  ADD KEY `id_obrazu` (`id_obrazu`);

--
-- Indeksy dla tabeli `kategorie`
--
ALTER TABLE `kategorie`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `nazwa` (`nazwa`);

--
-- Indeksy dla tabeli `komentarze`
--
ALTER TABLE `komentarze`
  ADD PRIMARY KEY (`id`),
  ADD KEY `Id publikacji exists` (`id_publikacji`),
  ADD KEY `Id uczestnika exists` (`id_uczestnika`);

--
-- Indeksy dla tabeli `obrazy`
--
ALTER TABLE `obrazy`
  ADD PRIMARY KEY (`id`);

--
-- Indeksy dla tabeli `polubienia`
--
ALTER TABLE `polubienia`
  ADD PRIMARY KEY (`id_publikacji`,`id_uczestnika`),
  ADD UNIQUE KEY `id_publikacji` (`id_publikacji`,`id_uczestnika`),
  ADD KEY `id_publikacji_2` (`id_publikacji`,`id_uczestnika`),
  ADD KEY `Is id uczestnika` (`id_uczestnika`);

--
-- Indeksy dla tabeli `uczestnicy`
--
ALTER TABLE `uczestnicy`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `email` (`email`);

--
-- Indeksy dla tabeli `tokeny`
--
ALTER TABLE `tokeny`
  ADD PRIMARY KEY (`id`),
  ADD KEY `token` (`token`);

--
-- AUTO_INCREMENT dla zrzuconych tabel
--

--
-- AUTO_INCREMENT dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT dla tabeli `kategorie`
--
ALTER TABLE `kategorie`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT dla tabeli `komentarze`
--
ALTER TABLE `komentarze`
  MODIFY `id` int(12) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=28;

--
-- AUTO_INCREMENT dla tabeli `obrazy`
--
ALTER TABLE `obrazy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=32;

--
-- AUTO_INCREMENT dla tabeli `uczestnicy`
--
ALTER TABLE `uczestnicy`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=14;

--
-- AUTO_INCREMENT dla tabeli `tokeny`
--
ALTER TABLE `tokeny`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=2;

--
-- Ograniczenia dla zrzuconych tabel
--

--
-- Ograniczenia dla tabeli `publikacje`
--
ALTER TABLE `publikacje`
  ADD CONSTRAINT `kategorie_exists` FOREIGN KEY (`id_kategorii`) REFERENCES `kategorie` (`id`),
  ADD CONSTRAINT `image_exists` FOREIGN KEY (`id_obrazu`) REFERENCES `obrazy` (`id`),
  ADD CONSTRAINT `member_exists` FOREIGN KEY (`id_uczestnika`) REFERENCES `uczestnicy` (`id`);

--
-- Ograniczenia dla tabeli `komentarze`
--
ALTER TABLE `komentarze`
  ADD CONSTRAINT `Id publikacji exists` FOREIGN KEY (`id_publikacji`) REFERENCES `publikacje` (`id`),
  ADD CONSTRAINT `Id uczestnika exists` FOREIGN KEY (`id_uczestnika`) REFERENCES `uczestnicy` (`id`);

--
-- Ograniczenia dla tabeli `polubienia`
--
ALTER TABLE `polubienia`
  ADD CONSTRAINT `Is id publikacji` FOREIGN KEY (`id_publikacji`) REFERENCES `publikacje` (`id`),
  ADD CONSTRAINT `Is id uczestnika` FOREIGN KEY (`id_uczestnika`) REFERENCES `uczestnicy` (`id`);
