<?php
declare(strict_types = 1);                                 // Włącz ścisłą kontrolę typów
include '../src/bootstrap.php';                            // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);  // Sprawdź id
if (!$id) {                                                // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';       // Nie odnaleziono strony
}

$kategoria = $cms->pobierzKategorie()->pobierz($id);        // Pobierz dane kategorii
if (!$kategoria) {                                          // Jeśli kategoria jest pusta
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';       // Nie odnaleziono strony
}

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko(); // Pobierz kategorie do nawigacji
$dane['kategoria']  = $kategoria;                                  // Bieżąca kategoria
$dane['publikacje'] = $cms->pobierzPublikacje()->pobierzWszystko(true, $id);  // Pobierz publikacje
$dane['sekcja']     = $kategoria['id'];                            // Id kategorii do nawigacji

echo $twig->render('kategoria.html', $dane);                // Wyrenderuj szablon