<?php
declare(strict_types = 1);                                  // Użyj ścisłej kontroli typów
require '../dolaczane/polaczenie-baza.php';                 // Połączenie z bazą
require '../dolaczane/funkcje.php';                         // Dołącz funkcje

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT); // Pobierz i sprawdź id
$obraz = [];                                              // Inicjalizacja tablicy $obraz

if ($id) {                                                // Jeśli nie ma prawidłowegi id; formularz niewysłany
    $sql = "SELECT o.id, o.plik, o.alt 
              FROM obrazy   AS o
              JOIN publikacje AS p
                ON o.id = p.id_obrazu
             WHERE p.id = :id;";                          // SQL pobierający dane obrazu
    $obraz = pdo($pdo, $sql, [$id])->fetch();             // Pobierz dane obrazu
}
if (!$obraz) {                                            // Jeśli nie ma obrazu
    przekieruj('publikacja.php', ['id' => $id]);          // Przekieruj
}

$sciezka = '../wyslane/' . $obraz['plik'];                   // Ścieżka do pliku

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                  // Jeśli formularz został wysłany
    $sql = "UPDATE publikacje SET id_obrazu = null WHERE id = :id_publikacji;"; // SQL usuwający obraz z tabeli publikacje
    pdo($pdo, $sql, [$id]);                                  // Usuń obraz z tabeli publikacje
    $sql = "DELETE FROM obrazy WHERE id = :id;";             // SQL usuwający obraz z tabeli obrazy
    pdo($pdo, $sql, [$obraz['id']]);                         // Usuń obraz z tabeli obrazy
    if (file_exists($sciezka)) {                             // Jeśli plik obrazu istnieje
        $unlink = unlink($sciezka);                          // Usuń go
    }
    przekieruj('publikacja.php', ['id' => $id]);             // Przekieruj
}
?>
<?php include '../dolaczane/admin-naglowek.php'; ?>
  <main class="container admin" id="content">
      <form action="usun-obraz.php?id=<?= $id ?>" method="POST" class="narrow">
        <h1>Usuń obraz</h1>
        <p><img src="../wyslane/<?= zastap_html($obraz['plik']) ?>" alt="<?= zastap_html($obraz['alt']) ?>"></p>
        <p>Kliknij <em>Potwierdź</em>, aby usunąć obraz:</p>
        <input type="submit" name="delete" value="Potwierdź" class="btn btn-primary" />
        <a href="publikacja.php?id=<?= $id ?>" class="btn btn-danger">Anuluj</a>
      </form>
  </main>
<?php include '../dolaczane/admin-stopka.php'; ?>