<?php
declare(strict_types = 1);                                    // Użyj ścisłej kontroli typów
require 'dolaczane/polaczenie-baza.php';                      // Utwórz obiekt PDO
require 'dolaczane/funkcje.php';                              // Dołącz funkcje

$termin  = filter_input(INPUT_GET, 'termin');                 // Pobierz szukany termin
$pokaz   = filter_input(INPUT_GET, 'pokaz', FILTER_VALIDATE_INT) ?? 3; // Ograniczenie
$od      = filter_input(INPUT_GET, 'od', FILTER_VALIDATE_INT) ?? 0;    // Przeskok
$liczba = 0;                                                  // Ustaw licznik na 0
$publikacje = [];                                             // Zainicjalizuj pustą tablicę publikacji

if ($termin) {                                                // Jeśli podany został szukany termin
    $argumenty['termin1'] = '%' . $termin .'%';               // Zapisz go w tablicy
    $argumenty['termin2'] = '%' . $termin .'%';               // w postaci trzech osobnych zastępników,
    $argumenty['termin3'] = '%' . $termin .'%';               // które nie mogą się powtarzać w SQL

    $sql = "SELECT COUNT(tytul) FROM publikacje
             WHERE tytul        LIKE :termin1
                OR podsumowanie LIKE :termin2
                OR tresc        LIKE :termin3
               AND opublikowano = 1;";                        // Ile publikacji pasuje do szukanego terminu
    $liczba = pdo($pdo, $sql, $argumenty)->fetchColumn();     // Zwróć liczbę

    if ($liczba > 0) {                                        // Jeśli znaleziono publikacje
        $argumenty['pokaz'] = $pokaz;                         // Dodaj je do tablicy
        $argumenty['od']    = $od;                            // na potrzeby stronicowania
        $sql = "SELECT p.id, p.tytul, p.podsumowanie, p.id_kategorii, p.id_uczestnika, 
                       k.nazwa     AS kategoria,
                       CONCAT(u.imie, ' ', u.nazwisko) AS autor,
                       o.plik      AS obraz_plik,
                       o.alt       AS obraz_alt 
                  FROM publikacje  AS p
                  JOIN kategorie   AS k    ON p.id_kategorii  = k.id
                  JOIN uczestnicy  AS u    ON p.id_uczestnika = u.id
                  LEFT JOIN obrazy AS o    ON p.id_obrazu     = o.id
                 WHERE p.tytul        LIKE :termin1
                    OR p.podsumowanie LIKE :termin2
                    OR p.tresc        LIKE :termin3
                   AND p.opublikowano = 1
              ORDER BY p.id DESC
                 LIMIT :pokaz 
                OFFSET :od;";                                  // Znajdź pasujące publikacje
        $publikacje = pdo($pdo, $sql, $argumenty)->fetchAll(); // Uruchom zapytanie i pobierz rezultaty
    }
	
}

// else $termin = '';

if ($liczba > $pokaz) {                                        // Jeśli dopasowań jest więcej niż dopuszcza zmienna $pokaz
    $liczba_stron  = ceil($liczba / $pokaz);                   // Oblicz liczbę stron
    $biezaca_strona = ceil($od / $pokaz) + 1;                  // Oblicz numer bieżącej strony
}

$sql = "SELECT id, nazwa FROM kategorie WHERE nawigacja = 1;"; // Zapytanie SQL o kategorie
$nawigacja  = pdo($pdo, $sql)->fetchAll();                     // Pobierz kategorie do nawigacji
$sekcja     = '';                                              // Bieżąca kategoria
$tytul       = 'Wyniki wyszukiwania dla ' . $termin;           // Zawartość znacznika <title>
$opis = $tytul . ' z Creative Folk';                           // Opis do znacznika <meta>

?>
<?php include 'dolaczane/naglowek.php'; ?>
  <main class="container" id="content">
    <section class="header">
      <form action="szukaj.php" method="get" class="form-search">
        <label for="search"><span>Wyszukaj: </span></label>
        <input type="text" name="termin" value="<?= zastap_html($termin) ?>" 
               id="search" placeholder="Wpisz szukany termin"  
        /><input type="submit" value="Szukaj" class="btn btn-search" />
      </form>
      <?php if ($termin) { ?><p><b>Znaleziono</b> <?= $liczba ?> wyników</p><?php } ?>
    </section>

    <section class="grid">
      <?php foreach ($publikacje as $publikacja) { ?>
      <article class="summary">
        <a href="publikacja.php?id=<?= $publikacja['id'] ?>">
          <img src="wyslane/<?= zastap_html($publikacja['obraz_plik'] ?? 'blank.png') ?>"
               alt="<?= zastap_html($publikacja['obraz_alt']) ?>">
          <h2><?= zastap_html($publikacja['tytul']) ?></h2>
          <p><?= zastap_html($publikacja['podsumowanie']) ?></p>
        </a>
        <p class="credit">
          Zamieszczono w <a href="kategoria.php?id=<?= $publikacja['id_kategorii'] ?>">
          <?= zastap_html($publikacja['kategoria']) ?></a>
          przez: <a href="uczestnik.php?id=<?= $publikacja['id_uczestnika'] ?>">
          <?= zastap_html($publikacja['autor']) ?></a>
        </p>
      </article>
      <?php } ?>
    </section>

    <?php if ($liczba > $pokaz) { ?>
    <nav class="pagination" role="navigation" aria-label="Nawigacja stronicowania">
      <ul>
      <?php for ($i = 1; $i <= $liczba_stron; $i++) { ?>
        <li>
          <a href="?termin=<?= $termin ?>&pokaz=<?= $pokaz ?>&od=<?= (($i - 1) * $pokaz) ?>"
            class="btn <?= ($i == $biezaca_strona) ? 'active" aria-current="true' : '' ?>">
            <?= $i ?>
          </a>
        </li>
      <?php } ?>
      </ul>
    </nav>
    <?php } ?>

  </main>
<?php include 'dolaczane/stopka.php'; ?>