<?php
declare(strict_types = 1);
$haslo = '';
$komunikat  = '';
function czy_haslo(string $haslo): bool
{
    if (
        mb_strlen($haslo) >= 8
        and preg_match('/[A-Z]/', $haslo)
        and preg_match('/[a-z]/', $haslo)
        and preg_match('/[0-9]/', $haslo)
    ) {
        return true;  // Wszystkie testy zaliczone
    }
    return false;     // Nieprawidłowe
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $haslo = $_POST['haslo'];
    $prawidlowe    = czy_haslo($haslo);
    $komunikat  = $prawidlowe ? 'Hasło jest prawidłowe' :
        'Hasło nie jest wystarczająco silne';
}
?>
<?php include 'dolaczane/naglowek.php'; ?>

<?= $komunikat ?>
<form action="sprawdzanie-hasla.php" method="POST">
  Hasło: <input type="password" name="haslo">
  <input type="submit" value="Zapisz">
</form>

<?php include 'dolaczane/stopka.php'; ?>