<?php
declare(strict_types = 1);                                    // Włączenie ścisłej kontroli typów
require 'dolaczane/sprawdzanie.php';                          // Funkcje sprawdzające

$uzytkownik = [
    'imie'  => '',
    'wiek'   => '',
    'warunki' => '',
];                                                            // Inicjalizacja tablicy $uzytkownik

$bledy = [
    'imie'  => '',
    'wiek'   => '',
    'warunki' => '',
];                                                            // Inicjalizacja tablicy $bledy
$komunikat = '';                                              // Inicjalizacja zmiennej $komunikat

if ($_SERVER['REQUEST_METHOD'] == 'POST') {                   // Jeśli formularz został przesłany
    $uzytkownik['imie']  = $_POST['imie'];                    // Pobierz imię
    $uzytkownik['wiek']   = $_POST['wiek'];                   // Pobierz wiek i sprawdź zgodę na warunki
    $uzytkownik['warunki'] = (isset($_POST['warunki']) and $_POST['warunki'] == true) ? true : false;

    $bledy['imie']  = czy_tekst($uzytkownik['imie'], 2, 20)   ? '' : 'Imię musi mieć od 2 do 20 znaków';
    $bledy['wiek']   = czy_liczba($uzytkownik['wiek'], 16, 65) ? '' : 'Musisz mieć 16-65 lat';
    $bledy['warunki'] = $uzytkownik['warunki']                  ? '' : 'Konieczna jest zgoda na warunki 
	korzystania z serwisu';                                   // Weryfikacja danych

    $niepoprawne = implode($bledy);                           // Łączenie komunikatów błędów
    if ($niepoprawne) {                                       // W razie błędów
        $komunikat = 'Prosimy o poprawienie błędów:';         // Nie przetwarzaj
    } else {                                                  // W innym przypadku
        $komunikat = 'Dane są prawidłowe';                    // Dane mogą być przetworzone
    }
}
?>
<?php include 'dolaczane/naglowek.php'; ?>

<?= $komunikat ?>
<form action="sprawdzanie-formularza.php" method="POST">
  Imię: <input type="text" name="imie" value="<?= htmlspecialchars($uzytkownik['imie']) ?>">
  <span class="error"><?= $bledy['imie'] ?></span><br>
  Wiek:  <input type="text" name="wiek" value="<?= htmlspecialchars($uzytkownik['wiek']) ?>">
  <span class="error"><?= $bledy['wiek'] ?></span><br>
  <input type="checkbox" name="warunki" value="true" <?= $uzytkownik['warunki'] ? 'checked' : '' ?>>
  Zgadzam się na warunki korzystania z serwisu
  <span class="error"><?= $bledy['warunki'] ?></span><br>
  <input type="submit" value="Zapisz">
</form>

<?php include 'dolaczane/stopka.php'; ?>