<?php
declare(strict_types = 1);

class Konto {
    public    NumerKonta   $numer;
    public    string       $typ;
    protected float        $stan;

    public function __construct(NumerKonta $numer, string $typ, float $stan = 0.00)
    {
        $this->numer  = $numer;
        $this->typ    = $typ;
        $this->stan = $stan;
    }

    public function wplac(float $kwota): float
    {
        $this->stan += $kwota;
        return $this->stan;
    }

    public function wyplac(float $kwota): float
    {
        $this->stan -= $kwota;
        return $this->stan;
    }

    public function sprawdzStan(): float
    {
        return $this->stan;
    }
}

class NumerKonta
{
    public int $numerKonta;
    public int $numerRozliczeniowy;
	
    public function __construct(int $numerKonta,  
                                int $numerRozliczeniowy)
    {
        $this->numerKonta = $numerKonta;
        $this->numerRozliczeniowy = $numerRozliczeniowy;
    }
}


// Utwórz obiekt do zapisania we właściwości
$numery = new NumerKonta(12345678, 987654321);
// Utwórz instancję klasy Konto i ustaw jej właściwości
$konto = new Konto($numery, 'Oszczędnościowe', 10.00);
?>
<?php include 'dolaczane/naglowek.php';?>
<h2>Konto <?= $konto->typ ?></h2>
Nr konta <?= $konto->numer->numerKonta ?><br>
Nr rozliczeniowy <?= $konto->numer->numerRozliczeniowy ?>
<?php include 'dolaczane/stopka.php'; ?>