<?php
declare(strict_types = 1);                                           // Włącz ścisłą kontrolę typów

$dane['term']    = filter_input(INPUT_GET, 'term');                  // Pobierz szukany termin
$dane['pokaz']   = filter_input(INPUT_GET, 'pokaz', FILTER_VALIDATE_INT) ?? 3; // Limit wyświetleń
$dane['od']      = filter_input(INPUT_GET, 'od', FILTER_VALIDATE_INT) ?? 0; // Przesunięcie

$dane['liczba']     = 0;                                             // Ustaw licznik na 0
$dane['$publikacje'] = [];                                           // Przypisz pustą tablicę zmiennej

if ($dane['term']) {                                                 // Jeśli podano szukany termin
    $dane['liczba'] = $cms->pobierzPublikacje()->policzWyniki($dane['term']); // Pobierz liczbę dopasowań
    if ($dane['liczba'] > 0) {                                       // Jeśli są dopasowania
        $dane['publikacje'] = $cms->pobierzPublikacje()->szukaj($dane['term'], $dane['pokaz'], $dane['od']); // Pobierz je
    }
}

if ($dane['liczba'] > $dane['pokaz']) {                               // Jeśli są więcej niż 3 dopasowania
    $dane['liczba_stron']  = ceil($dane['liczba'] / $dane['pokaz']);  // Określ liczbę stron
    $dane['biezaca_strona'] = ceil($dane['od'] / $dane['pokaz']) + 1; // Określ bieżącą stronę
}

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko();   // Pobierz kategorie

echo $twig->render('szukaj.html', $dane);                            // Wyrenderuj szablon