<?php
namespace PhpMysql\CMS;                                  // Deklaracja przestrzeni nazw

class Token
{
    protected $db;                                       // Odwołanie do obiektu Baza

    public function __construct(Baza $db)                // Zostaje wywołana przy tworzeniu obiektu tej klasy
    {
        $this->db = $db;                                 // Zapisz obiekt Baza we właściwości $db
    }

    // Tworzy nowy token (wymaga podania id uczestnika i celu użycia tokena)
    public function utworz(int $id, string $cel): string
    {
        $argumenty['token']         = bin2hex(random_bytes(64));                  // Token
        $argumenty['wygasa']        = date("Y-m-d H:i:s", strtotime('+4 hours')); // Wygasa
        $argumenty['id_uczestnika'] = $id;                                        // Id uczestnika
        $argumenty['cel']   = $cel;                                               // Cel zastosowania
        $sql     = "INSERT INTO tokeny (token, id_uczestnika, wygasa, cel)
                    VALUES (:token, :id_uczestnika, :wygasa, :cel);";             // SQL dodający token do bazy
        $this->db->wykonajSQL($sql, $argumenty);                                  // Wykonaj instrukcję SQL
        return $argumenty['token'];                                               // Zwróć nowy token
    }

    // Sprawdź poprawność tokena
    public function pobierzIdUczestnika(string $token, string $cel): ?int
    {
        $sql = "SELECT id_uczestnika
                  FROM tokeny
                 WHERE token = :token AND cel = :cel
                   AND wygasa > NOW();";                                          // SQL sprawdzający poprawność tokena
        return $this->db->wykonajSQL($sql, ['token' => $token, 'cel' => $cel])->fetchColumn(); // Wykonaj SQL
    }
}