<?php
declare(strict_types = 1);                               // Włącz ścisłą kontrolę typów
include '../src/bootstrap.php';                          // Plik konfiguracyjny

$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);// Sprawdź id
if (!$id) {                                              // Jeśli nie ma prawidłowego id
    include APP_ROOT . '/public/nie-odnaleziono-strony.php';  // Nie znaleziono strony
}

$uczestnik = $cms->pobierzUczestnika()->pobierz($id);    // Pobierz dane użytkownika

$dane['nawigacja']  = $cms->pobierzKategorie()->pobierzWszystko();   // Pobierz kategorie
$dane['uczestnik']   = $uczestnik;                                   // Dane użytkownika
$dane['sukces']      = $_GET['sukces'] ?? '';                        // Komunikat o powodzeniu
$dane['publikacje']  = $cms->pobierzPublikacje()->pobierzWszystko(true, null, $id); // Pobierz publikacje uczestnika

echo $twig->render('uczestnik.html', $dane);                         // Wyrenderuj szablon